package com.casper.sdk.model.clvalue.cltype;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;

/**
 * CLType for {@link AbstractCLType#I64}
 *
 * @author Alexandre Carvalho
 * @author Andre Bertolace
 * @see AbstractCLType
 * @since 0.0.1
 */
@Getter
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false, of = {"typeName"})
public class CLTypeI64 extends AbstractCLTypeBasic {
    private final String typeName = I64;

    @JsonCreator
    protected CLTypeI64(final String typeName) {
        super(typeName);
    }
}
