/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.helper;

import com.syntifi.crypto.key.Ed25519PrivateKey;
import com.syntifi.crypto.key.Ed25519PublicKey;
import com.syntifi.crypto.key.Secp256k1PrivateKey;
import com.syntifi.crypto.key.Secp256k1PublicKey;
import java.io.IOException;

public class CasperKeyHelper {
    public static Ed25519PrivateKey createRandomEd25519Key() {
        return Ed25519PrivateKey.deriveRandomKey();
    }

    public static Secp256k1PrivateKey createRandomSecp256k1Key() throws IOException {
        return Secp256k1PrivateKey.deriveRandomKey();
    }

    public static Ed25519PublicKey derivePublicKey(Ed25519PrivateKey privateKey) {
        return (Ed25519PublicKey)privateKey.derivePublicKey();
    }

    public static Secp256k1PublicKey derivePublicKey(Secp256k1PrivateKey privateKey) {
        return (Secp256k1PublicKey)privateKey.derivePublicKey();
    }

    private CasperKeyHelper() {
    }
}

