/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.deploy;

import com.casper.sdk.annotation.ExcludeFromJacocoGeneratedReport;
import com.casper.sdk.model.uref.URef;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;
import java.util.List;

public class DeployInfo {
    @JsonProperty(value="deploy_hash")
    private String hash;
    private String from;
    @JsonIgnore
    private BigInteger gas;
    private URef source;
    private List<String> transfers;

    @JsonProperty(value="gas")
    @ExcludeFromJacocoGeneratedReport
    protected String getJsonGas() {
        return this.gas.toString(10);
    }

    @JsonProperty(value="gas")
    @ExcludeFromJacocoGeneratedReport
    protected void setJsonGas(String value) {
        this.gas = new BigInteger(value, 10);
    }

    public static DeployInfoBuilder builder() {
        return new DeployInfoBuilder();
    }

    public String getHash() {
        return this.hash;
    }

    public String getFrom() {
        return this.from;
    }

    public BigInteger getGas() {
        return this.gas;
    }

    public URef getSource() {
        return this.source;
    }

    public List<String> getTransfers() {
        return this.transfers;
    }

    @JsonProperty(value="deploy_hash")
    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    @JsonIgnore
    public void setGas(BigInteger gas) {
        this.gas = gas;
    }

    public void setSource(URef source) {
        this.source = source;
    }

    public void setTransfers(List<String> transfers) {
        this.transfers = transfers;
    }

    public DeployInfo(String hash, String from, BigInteger gas, URef source, List<String> transfers) {
        this.hash = hash;
        this.from = from;
        this.gas = gas;
        this.source = source;
        this.transfers = transfers;
    }

    public DeployInfo() {
    }

    public static class DeployInfoBuilder {
        private String hash;
        private String from;
        private BigInteger gas;
        private URef source;
        private List<String> transfers;

        DeployInfoBuilder() {
        }

        @JsonProperty(value="deploy_hash")
        public DeployInfoBuilder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public DeployInfoBuilder from(String from) {
            this.from = from;
            return this;
        }

        @JsonIgnore
        public DeployInfoBuilder gas(BigInteger gas) {
            this.gas = gas;
            return this;
        }

        public DeployInfoBuilder source(URef source) {
            this.source = source;
            return this;
        }

        public DeployInfoBuilder transfers(List<String> transfers) {
            this.transfers = transfers;
            return this;
        }

        public DeployInfo build() {
            return new DeployInfo(this.hash, this.from, this.gas, this.source, this.transfers);
        }

        public String toString() {
            return "DeployInfo.DeployInfoBuilder(hash=" + this.hash + ", from=" + this.from + ", gas=" + this.gas + ", source=" + this.source + ", transfers=" + this.transfers + ")";
        }
    }
}

