/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.deploy;

import com.casper.sdk.annotation.ExcludeFromJacocoGeneratedReport;
import com.casper.sdk.model.key.PublicKey;
import com.casper.sdk.model.uref.URef;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;

public class UnbondingPurse {
    @JsonProperty(value="amount")
    private BigInteger unbondingAmount;
    @JsonIgnore
    private BigInteger amount;
    @JsonProperty(value="bonding_purse")
    private URef bondingPurse;
    @JsonProperty(value="era_of_creation")
    private BigInteger eraOfCreation;
    @JsonProperty(value="unbonder_public_key")
    private PublicKey unbonderPublicKey;
    @JsonProperty(value="validator_public_key")
    private PublicKey validatorPublicKey;

    @JsonProperty(value="unbonding_amount")
    @ExcludeFromJacocoGeneratedReport
    protected String getJsonUnbondingAmount() {
        return this.unbondingAmount.toString(10);
    }

    @JsonProperty(value="unbonding_amount")
    @ExcludeFromJacocoGeneratedReport
    protected void setJsonUnbondingAmount(String value) {
        this.unbondingAmount = new BigInteger(value, 10);
    }

    public static UnbondingPurseBuilder builder() {
        return new UnbondingPurseBuilder();
    }

    public BigInteger getUnbondingAmount() {
        return this.unbondingAmount;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public URef getBondingPurse() {
        return this.bondingPurse;
    }

    public BigInteger getEraOfCreation() {
        return this.eraOfCreation;
    }

    public PublicKey getUnbonderPublicKey() {
        return this.unbonderPublicKey;
    }

    public PublicKey getValidatorPublicKey() {
        return this.validatorPublicKey;
    }

    @JsonProperty(value="amount")
    public void setUnbondingAmount(BigInteger unbondingAmount) {
        this.unbondingAmount = unbondingAmount;
    }

    @JsonIgnore
    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    @JsonProperty(value="bonding_purse")
    public void setBondingPurse(URef bondingPurse) {
        this.bondingPurse = bondingPurse;
    }

    @JsonProperty(value="era_of_creation")
    public void setEraOfCreation(BigInteger eraOfCreation) {
        this.eraOfCreation = eraOfCreation;
    }

    @JsonProperty(value="unbonder_public_key")
    public void setUnbonderPublicKey(PublicKey unbonderPublicKey) {
        this.unbonderPublicKey = unbonderPublicKey;
    }

    @JsonProperty(value="validator_public_key")
    public void setValidatorPublicKey(PublicKey validatorPublicKey) {
        this.validatorPublicKey = validatorPublicKey;
    }

    public UnbondingPurse(BigInteger unbondingAmount, BigInteger amount, URef bondingPurse, BigInteger eraOfCreation, PublicKey unbonderPublicKey, PublicKey validatorPublicKey) {
        this.unbondingAmount = unbondingAmount;
        this.amount = amount;
        this.bondingPurse = bondingPurse;
        this.eraOfCreation = eraOfCreation;
        this.unbonderPublicKey = unbonderPublicKey;
        this.validatorPublicKey = validatorPublicKey;
    }

    public UnbondingPurse() {
    }

    public static class UnbondingPurseBuilder {
        private BigInteger unbondingAmount;
        private BigInteger amount;
        private URef bondingPurse;
        private BigInteger eraOfCreation;
        private PublicKey unbonderPublicKey;
        private PublicKey validatorPublicKey;

        UnbondingPurseBuilder() {
        }

        @JsonProperty(value="amount")
        public UnbondingPurseBuilder unbondingAmount(BigInteger unbondingAmount) {
            this.unbondingAmount = unbondingAmount;
            return this;
        }

        @JsonIgnore
        public UnbondingPurseBuilder amount(BigInteger amount) {
            this.amount = amount;
            return this;
        }

        @JsonProperty(value="bonding_purse")
        public UnbondingPurseBuilder bondingPurse(URef bondingPurse) {
            this.bondingPurse = bondingPurse;
            return this;
        }

        @JsonProperty(value="era_of_creation")
        public UnbondingPurseBuilder eraOfCreation(BigInteger eraOfCreation) {
            this.eraOfCreation = eraOfCreation;
            return this;
        }

        @JsonProperty(value="unbonder_public_key")
        public UnbondingPurseBuilder unbonderPublicKey(PublicKey unbonderPublicKey) {
            this.unbonderPublicKey = unbonderPublicKey;
            return this;
        }

        @JsonProperty(value="validator_public_key")
        public UnbondingPurseBuilder validatorPublicKey(PublicKey validatorPublicKey) {
            this.validatorPublicKey = validatorPublicKey;
            return this;
        }

        public UnbondingPurse build() {
            return new UnbondingPurse(this.unbondingAmount, this.amount, this.bondingPurse, this.eraOfCreation, this.unbonderPublicKey, this.validatorPublicKey);
        }

        public String toString() {
            return "UnbondingPurse.UnbondingPurseBuilder(unbondingAmount=" + this.unbondingAmount + ", amount=" + this.amount + ", bondingPurse=" + this.bondingPurse + ", eraOfCreation=" + this.eraOfCreation + ", unbonderPublicKey=" + this.unbonderPublicKey + ", validatorPublicKey=" + this.validatorPublicKey + ")";
        }
    }
}

