/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.key;

import com.casper.sdk.exception.NoSuchKeyTagException;
import com.casper.sdk.jackson.deserializer.KeyDeserializer;
import com.casper.sdk.model.key.AbstractSerializedKeyTaggedHex;
import com.casper.sdk.model.key.KeyTag;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.syntifi.crypto.key.hash.Blake2b;
import dev.oak3.sbs4j.util.ByteUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;

@JsonDeserialize(using=KeyDeserializer.class)
public class Key
extends AbstractSerializedKeyTaggedHex<KeyTag> {
    public static Key fromTaggedHexString(String hex) throws NoSuchKeyTagException {
        Key object = new Key();
        byte[] bytes = ByteUtils.parseHexString((String)hex);
        object.setTag(KeyTag.getByTag(bytes[0]));
        object.setKey(Arrays.copyOfRange(bytes, 1, bytes.length));
        return object;
    }

    public String generateAccountHash(boolean includePrefix) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(((KeyTag)this.getTag()).toString().toLowerCase().getBytes("UTF-8"));
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(this.getKey());
        return (includePrefix ? "account-hash-" : "") + ByteUtils.encodeHexString((byte[])Blake2b.digest(byteArrayOutputStream.toByteArray(), 32));
    }

    @JsonCreator
    public void createKey(String key) throws NoSuchKeyTagException {
        Key obj = Key.fromTaggedHexString(key);
        this.setTag((KeyTag)obj.getTag());
        this.setKey(obj.getKey());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key other = (Key)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Key;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

