/*
 * Decompiled with CFR 0.152.
 */
package com.syntifi.crypto.key.deterministic;

import com.syntifi.crypto.key.encdec.Hex;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

public class HierarchicalDeterministicKey {
    private static final Long MAX_VALUE_INDEX = 0x80000000L;

    public static byte[] getFromSeed(byte[] seed, byte[] init, int[] derivationPath) throws IOException {
        byte[] key = HierarchicalDeterministicKey.getMasterKeyFromSeed(seed, init);
        byte[] iL = Arrays.copyOfRange(key, 0, 32);
        byte[] iR = Arrays.copyOfRange(key, 32, 64);
        for (int i : derivationPath) {
            key = HierarchicalDeterministicKey.childKeyDerivation(iL, iR, HierarchicalDeterministicKey.longToBytes(MAX_VALUE_INDEX + (long)i));
            iL = Arrays.copyOfRange(key, 0, 32);
            iR = Arrays.copyOfRange(key, 32, 64);
        }
        return key;
    }

    public static byte[] getMasterKeyFromSeed(byte[] seed, byte[] key) {
        HMac hMac = new HMac((Digest)new SHA512Digest());
        hMac.init((CipherParameters)new KeyParameter(key));
        hMac.update(seed, 0, seed.length);
        byte[] result = new byte[hMac.getMacSize()];
        hMac.doFinal(result, 0);
        return result;
    }

    public static byte[] childKeyDerivation(byte[] key, byte[] chainCode, byte[] init) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(Hex.decode("00"));
        os.write(key);
        os.write(Arrays.copyOfRange(init, 4, 8));
        HMac hMac = new HMac((Digest)new SHA512Digest());
        hMac.init((CipherParameters)new KeyParameter(chainCode));
        hMac.update(os.toByteArray(), 0, os.size());
        byte[] result = new byte[hMac.getMacSize()];
        hMac.doFinal(result, 0);
        return result;
    }

    private static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }
}

