/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.jackson.deserializer;

import com.casper.sdk.exception.NoSuchTypeException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;

public abstract class AbstractAnyOfDeserializer
extends AsPropertyTypeDeserializer {
    protected AbstractAnyOfDeserializer(JavaType bt, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, JavaType defaultImpl) {
        super(bt, idRes, typePropertyName, typeIdVisible, defaultImpl);
    }

    protected AbstractAnyOfDeserializer(AsPropertyTypeDeserializer src, BeanProperty property) {
        super(src, property);
    }

    public Object deserializeTypedFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Class<?> subType;
        JsonNode node = (JsonNode)jp.readValueAsTree();
        JsonNode subTypeNode = this.getTypeNode(node);
        try {
            String anyOfType = subTypeNode.isObject() ? (String)subTypeNode.fieldNames().next() : subTypeNode.asText();
            subType = this.getClassByName(anyOfType);
        }
        catch (NoSuchTypeException e) {
            throw new IOException("Parse error", e);
        }
        TypeFactory factory = ctxt.getTypeFactory();
        JavaType type = factory.constructType(subType);
        try (TreeTraversingParser jsonParser = new TreeTraversingParser(node, jp.getCodec());){
            if (jsonParser.getCurrentToken() == null) {
                jsonParser.nextToken();
            }
            JsonDeserializer deser = ctxt.findContextualValueDeserializer(type, this._property);
            Object object = deser.deserialize((JsonParser)jsonParser, ctxt);
            return object;
        }
    }

    protected JsonNode getTypeNode(JsonNode currentNode) {
        return currentNode;
    }

    protected abstract Class<?> getClassByName(String var1) throws NoSuchTypeException;
}

