/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.clvalue.cltype;

import com.casper.sdk.annotation.ExcludeFromJacocoGeneratedReport;
import com.casper.sdk.exception.DynamicInstanceException;
import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.cltype.AbstractCLType;
import com.casper.sdk.model.clvalue.cltype.AbstractCLTypeBasic;
import com.casper.sdk.model.clvalue.cltype.AbstractCLTypeWithChildren;
import com.casper.sdk.model.clvalue.cltype.CLTypeAny;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import dev.oak3.sbs4j.DeserializerBuffer;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueDeserializationException;
import java.util.List;

public class CLTypeMap
extends AbstractCLTypeWithChildren {
    private final String typeName = "Map";
    private CLTypeMapEntryType keyValueTypes;

    @JsonProperty(value="Map")
    public void setKeyValueTypes(CLTypeMapEntryType keyValueTypes) {
        this.keyValueTypes = keyValueTypes;
        this.getChildTypes().add(this.keyValueTypes.getKeyType());
        this.getChildTypes().add(this.keyValueTypes.getValueType());
    }

    @Override
    public boolean isDeserializable() {
        if (this.getKeyValueTypes().keyType instanceof CLTypeAny || this.getKeyValueTypes().valueType instanceof CLTypeAny) {
            return false;
        }
        if (this.getKeyValueTypes().valueType instanceof AbstractCLTypeWithChildren) {
            return this.getChildTypes().stream().allMatch(childType -> {
                if (childType instanceof CLTypeAny) {
                    return false;
                }
                return childType.isDeserializable();
            });
        }
        return this.getKeyValueTypes().keyType.isDeserializable() || this.getKeyValueTypes().valueType.isDeserializable();
    }

    @Override
    public void setChildTypes(List<AbstractCLType> childTypes) {
        super.setChildTypes(childTypes);
        if (childTypes.size() >= 2) {
            this.setKeyValueTypes(new CLTypeMapEntryType(childTypes.get(0), childTypes.get(1)));
        }
    }

    @Override
    public void serializeChildTypes(SerializerBuffer ser) throws NoSuchTypeException {
        this.getKeyValueTypes().getKeyType().serialize(ser);
        this.getKeyValueTypes().getValueType().serialize(ser);
    }

    @Override
    public void deserializeChildTypes(DeserializerBuffer deser) throws ValueDeserializationException, NoSuchTypeException, DynamicInstanceException {
        AbstractCLType clTypeKey = this.deserializeChildType(deser);
        AbstractCLType clTypeValue = this.deserializeChildType(deser);
        this.setKeyValueTypes(new CLTypeMapEntryType(clTypeKey, clTypeValue));
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    public CLTypeMapEntryType getKeyValueTypes() {
        return this.keyValueTypes;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CLTypeMap)) {
            return false;
        }
        CLTypeMap other = (CLTypeMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        CLTypeMapEntryType this$keyValueTypes = this.getKeyValueTypes();
        CLTypeMapEntryType other$keyValueTypes = other.getKeyValueTypes();
        return !(this$keyValueTypes == null ? other$keyValueTypes != null : !((Object)this$keyValueTypes).equals(other$keyValueTypes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CLTypeMap;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        CLTypeMapEntryType $keyValueTypes = this.getKeyValueTypes();
        result = result * 59 + ($keyValueTypes == null ? 43 : ((Object)$keyValueTypes).hashCode());
        return result;
    }

    public static class CLTypeMapEntryType {
        @JsonIgnore
        private AbstractCLType keyType;
        @JsonIgnore
        private AbstractCLType valueType;

        @JsonSetter(value="key")
        @ExcludeFromJacocoGeneratedReport
        protected void setJsonKey(AbstractCLType clType) {
            this.keyType = clType;
        }

        @JsonGetter(value="key")
        @ExcludeFromJacocoGeneratedReport
        protected Object getJsonKey() {
            if (this.keyType instanceof AbstractCLTypeBasic) {
                return this.keyType.getTypeName();
            }
            return this.keyType;
        }

        @JsonSetter(value="value")
        @ExcludeFromJacocoGeneratedReport
        protected void setJsonValue(AbstractCLType clType) {
            this.valueType = clType;
        }

        @JsonGetter(value="value")
        @ExcludeFromJacocoGeneratedReport
        protected Object getJsonValue() {
            if (this.valueType instanceof AbstractCLTypeBasic) {
                return this.valueType.getTypeName();
            }
            return this.valueType;
        }

        public AbstractCLType getKeyType() {
            return this.keyType;
        }

        public AbstractCLType getValueType() {
            return this.valueType;
        }

        @JsonIgnore
        public void setKeyType(AbstractCLType keyType) {
            this.keyType = keyType;
        }

        @JsonIgnore
        public void setValueType(AbstractCLType valueType) {
            this.valueType = valueType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CLTypeMapEntryType)) {
                return false;
            }
            CLTypeMapEntryType other = (CLTypeMapEntryType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AbstractCLType this$keyType = this.getKeyType();
            AbstractCLType other$keyType = other.getKeyType();
            if (this$keyType == null ? other$keyType != null : !this$keyType.equals(other$keyType)) {
                return false;
            }
            AbstractCLType this$valueType = this.getValueType();
            AbstractCLType other$valueType = other.getValueType();
            return !(this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CLTypeMapEntryType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AbstractCLType $keyType = this.getKeyType();
            result = result * 59 + ($keyType == null ? 43 : $keyType.hashCode());
            AbstractCLType $valueType = this.getValueType();
            result = result * 59 + ($valueType == null ? 43 : $valueType.hashCode());
            return result;
        }

        public CLTypeMapEntryType() {
        }

        public CLTypeMapEntryType(AbstractCLType keyType, AbstractCLType valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }
    }
}

