/*
 * Decompiled with CFR 0.152.
 */
package com.syntifi.crypto.key;

import com.syntifi.crypto.key.AbstractPublicKey;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.util.Arrays;

public abstract class AbstractPrivateKey {
    private byte[] key;

    public abstract void loadPrivateKey(byte[] var1) throws IOException;

    public final void readPrivateKey(String filename) throws IOException {
        try (FileReader fileReader = new FileReader(filename);){
            this.readPrivateKey(fileReader);
        }
    }

    public abstract void readPrivateKey(Reader var1) throws IOException;

    public final void writePrivateKey(String filename) throws IOException {
        try (FileWriter fileWriter = new FileWriter(filename);){
            this.writePrivateKey(fileWriter);
        }
    }

    public abstract void writePrivateKey(Writer var1) throws IOException;

    public abstract byte[] sign(byte[] var1) throws GeneralSecurityException;

    public abstract AbstractPublicKey derivePublicKey();

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(byte[] key) {
        this.key = key;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractPrivateKey)) {
            return false;
        }
        AbstractPrivateKey other = (AbstractPrivateKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getKey(), other.getKey());
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractPrivateKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getKey());
        return result;
    }

    public String toString() {
        return "AbstractPrivateKey(key=" + Arrays.toString(this.getKey()) + ")";
    }

    public AbstractPrivateKey() {
    }

    public AbstractPrivateKey(byte[] key) {
        this.key = key;
    }
}

