/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.common;

import com.casper.sdk.model.clvalue.serde.CasperSerializableObject;
import com.casper.sdk.model.clvalue.serde.Target;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.oak3.sbs4j.SerializerBuffer;
import java.util.Arrays;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;

public class Digest
implements CasperSerializableObject {
    @JsonValue
    private String digest;

    public byte[] getDigest() {
        return Hex.decode((String)this.digest);
    }

    public void setDigest(byte[] hash) {
        this.digest = Hex.toHexString((byte[])hash);
    }

    public static Digest digestFromBytes(byte[] bytes) {
        Digest digest = new Digest();
        digest.setDigest(bytes);
        return digest;
    }

    @Override
    public void serialize(SerializerBuffer ser, Target target) {
        ser.writeByteArray(this.getDigest());
    }

    public String toString() {
        return this.digest;
    }

    @JsonIgnore
    public boolean isValid() {
        try {
            Hex.decode((String)this.digest);
            return true;
        }
        catch (DecoderException e) {
            return false;
        }
    }

    public static DigestBuilder builder() {
        return new DigestBuilder();
    }

    public Digest() {
    }

    public Digest(String digest) {
        this.digest = digest;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Digest)) {
            return false;
        }
        Digest other = (Digest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getDigest(), other.getDigest());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Digest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getDigest());
        return result;
    }

    public static class DigestBuilder {
        private String digest;

        DigestBuilder() {
        }

        public DigestBuilder digest(String digest) {
            this.digest = digest;
            return this;
        }

        public Digest build() {
            return new Digest(this.digest);
        }

        public String toString() {
            return "Digest.DigestBuilder(digest=" + this.digest + ")";
        }
    }
}

