/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.deploy;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.serde.CasperSerializableObject;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.common.Digest;
import com.casper.sdk.model.deploy.Approval;
import com.casper.sdk.model.deploy.DeployHeader;
import com.casper.sdk.model.deploy.executabledeploy.ExecutableDeployItem;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.util.List;

public class Deploy
implements CasperSerializableObject {
    private Digest hash;
    private DeployHeader header;
    private List<Approval> approvals;
    private ExecutableDeployItem payment;
    private ExecutableDeployItem session;

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws NoSuchTypeException, ValueSerializationException {
        this.header.serialize(ser, Target.BYTE);
        this.hash.serialize(ser, Target.BYTE);
        this.payment.serialize(ser, Target.BYTE);
        this.session.serialize(ser, Target.BYTE);
        ser.writeI32(this.approvals.size());
        for (Approval approval : this.approvals) {
            approval.serialize(ser, Target.BYTE);
        }
    }

    public static DeployBuilder builder() {
        return new DeployBuilder();
    }

    public Digest getHash() {
        return this.hash;
    }

    public DeployHeader getHeader() {
        return this.header;
    }

    public List<Approval> getApprovals() {
        return this.approvals;
    }

    public ExecutableDeployItem getPayment() {
        return this.payment;
    }

    public ExecutableDeployItem getSession() {
        return this.session;
    }

    public void setHash(Digest hash) {
        this.hash = hash;
    }

    public void setHeader(DeployHeader header) {
        this.header = header;
    }

    public void setApprovals(List<Approval> approvals) {
        this.approvals = approvals;
    }

    public void setPayment(ExecutableDeployItem payment) {
        this.payment = payment;
    }

    public void setSession(ExecutableDeployItem session) {
        this.session = session;
    }

    public Deploy(Digest hash, DeployHeader header, List<Approval> approvals, ExecutableDeployItem payment, ExecutableDeployItem session) {
        this.hash = hash;
        this.header = header;
        this.approvals = approvals;
        this.payment = payment;
        this.session = session;
    }

    public Deploy() {
    }

    public static class DeployBuilder {
        private Digest hash;
        private DeployHeader header;
        private List<Approval> approvals;
        private ExecutableDeployItem payment;
        private ExecutableDeployItem session;

        DeployBuilder() {
        }

        public DeployBuilder hash(Digest hash) {
            this.hash = hash;
            return this;
        }

        public DeployBuilder header(DeployHeader header) {
            this.header = header;
            return this;
        }

        public DeployBuilder approvals(List<Approval> approvals) {
            this.approvals = approvals;
            return this;
        }

        public DeployBuilder payment(ExecutableDeployItem payment) {
            this.payment = payment;
            return this;
        }

        public DeployBuilder session(ExecutableDeployItem session) {
            this.session = session;
            return this;
        }

        public Deploy build() {
            return new Deploy(this.hash, this.header, this.approvals, this.payment, this.session);
        }

        public String toString() {
            return "Deploy.DeployBuilder(hash=" + this.hash + ", header=" + this.header + ", approvals=" + this.approvals + ", payment=" + this.payment + ", session=" + this.session + ")";
        }
    }
}

