/*
 * Decompiled with CFR 0.152.
 */
package com.syntifi.crypto.key;

import com.syntifi.crypto.key.ASN1Identifiers;
import com.syntifi.crypto.key.AbstractPublicKey;
import com.syntifi.crypto.key.PemFileHelper;
import com.syntifi.crypto.key.encdec.Hex;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Sign;

public class Secp256k1PublicKey
extends AbstractPublicKey {
    public Secp256k1PublicKey(byte[] bytes) {
        super(bytes);
    }

    @Override
    public void loadPublicKey(byte[] publicKey) throws IOException {
        ASN1Primitive derKey = ASN1Primitive.fromByteArray((byte[])publicKey);
        ASN1Sequence objBaseSeq = ASN1Sequence.getInstance((Object)derKey);
        String keyId = ASN1ObjectIdentifier.getInstance((Object)ASN1Sequence.getInstance((Object)objBaseSeq.getObjectAt(0)).getObjectAt(0)).getId();
        String curveId = ASN1ObjectIdentifier.getInstance((Object)ASN1Sequence.getInstance((Object)objBaseSeq.getObjectAt(0)).getObjectAt(1)).getId();
        if (!curveId.equals(ASN1Identifiers.Secp256k1OIDCurve.getId()) || !keyId.equals(ASN1Identifiers.Secp256k1OIDkey.getId())) {
            throw new IOException();
        }
        DERBitString key = DERBitString.getInstance((Object)objBaseSeq.getObjectAt(1));
        this.setKey(key.getBytes());
    }

    @Override
    public void readPublicKey(Reader reader) throws IOException {
        this.loadPublicKey(PemFileHelper.readPemFile(reader));
    }

    @Override
    public void writePublicKey(Writer writer) throws IOException {
        DERBitString key = new DERBitString(this.getKey());
        ASN1EncodableVector v1 = new ASN1EncodableVector();
        v1.add((ASN1Encodable)ASN1Identifiers.Secp256k1OIDkey);
        v1.add((ASN1Encodable)ASN1Identifiers.Secp256k1OIDCurve);
        DERSequence derPrefix = new DERSequence(v1);
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add((ASN1Encodable)derPrefix);
        v2.add((ASN1Encodable)key);
        DERSequence derKey = new DERSequence(v2);
        PemFileHelper.writePemFile(writer, derKey.getEncoded(), "PUBLIC KEY");
    }

    @Override
    public Boolean verify(byte[] message, byte[] signature) throws GeneralSecurityException {
        Sign.SignatureData signatureData1 = new Sign.SignatureData(27, Arrays.copyOfRange(signature, 0, 32), Arrays.copyOfRange(signature, 32, 64));
        BigInteger derivedKey1 = Sign.signedMessageHashToKey((byte[])Hash.sha256((byte[])message), (Sign.SignatureData)signatureData1);
        Sign.SignatureData signatureData2 = new Sign.SignatureData(28, Arrays.copyOfRange(signature, 0, 32), Arrays.copyOfRange(signature, 32, 64));
        BigInteger derivedKey2 = Sign.signedMessageHashToKey((byte[])Hash.sha256((byte[])message), (Sign.SignatureData)signatureData2);
        return Arrays.equals(Secp256k1PublicKey.getShortKey(derivedKey1.toByteArray()), this.getKey()) || Arrays.equals(Secp256k1PublicKey.getShortKey(derivedKey2.toByteArray()), this.getKey());
    }

    public static byte[] getShortKey(byte[] key) {
        BigInteger pubKey = new BigInteger(key);
        String pubKeyPrefix = pubKey.testBit(0) ? "03" : "02";
        byte[] pubKeyBytes = Arrays.copyOfRange(key, 0, 32);
        return Hex.decode(pubKeyPrefix + Hex.encode(pubKeyBytes));
    }

    public Secp256k1PublicKey() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Secp256k1PublicKey)) {
            return false;
        }
        Secp256k1PublicKey other = (Secp256k1PublicKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Secp256k1PublicKey;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

