/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.helper;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.helper.CasperConstants;
import com.casper.sdk.helper.CasperDeployHelper;
import com.casper.sdk.model.clvalue.CLValueOption;
import com.casper.sdk.model.clvalue.CLValuePublicKey;
import com.casper.sdk.model.clvalue.CLValueU512;
import com.casper.sdk.model.clvalue.CLValueU64;
import com.casper.sdk.model.clvalue.cltype.CLTypePublicKey;
import com.casper.sdk.model.clvalue.cltype.CLTypeU512;
import com.casper.sdk.model.common.Digest;
import com.casper.sdk.model.common.Ttl;
import com.casper.sdk.model.deploy.Deploy;
import com.casper.sdk.model.deploy.NamedArg;
import com.casper.sdk.model.deploy.executabledeploy.ModuleBytes;
import com.casper.sdk.model.deploy.executabledeploy.Transfer;
import com.casper.sdk.model.key.PublicKey;
import com.syntifi.crypto.key.AbstractPrivateKey;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;

public class CasperTransferHelper {
    public static Deploy buildTransferDeploy(AbstractPrivateKey from, PublicKey to, BigInteger amount, String chainName) throws NoSuchTypeException, GeneralSecurityException, ValueSerializationException {
        long id = Math.abs(new Random().nextInt());
        Ttl ttl = Ttl.builder().ttl(CasperConstants.DEFAULT_DEPLOY_TTL.value / 60L / 1000L + "m").build();
        BigInteger paymentAmount = BigInteger.valueOf(CasperConstants.STANDARD_PAYMENT_FOR_NATIVE_TRANSFERS.value);
        return CasperTransferHelper.buildTransferDeploy(from, to, amount, chainName, id, paymentAmount, CasperConstants.DEFAULT_GAS_PRICE.value, ttl, new Date(), new ArrayList<Digest>());
    }

    public static Deploy buildTransferDeploy(AbstractPrivateKey signer, PublicKey to, BigInteger amount, String chainName, Long id, BigInteger paymentAmount, Long gasPrice, Ttl ttl, Date date, List<Digest> dependencies) throws NoSuchTypeException, GeneralSecurityException, ValueSerializationException {
        LinkedList transferArgs = new LinkedList();
        NamedArg<CLTypeU512> amountNamedArg = new NamedArg<CLTypeU512>("amount", new CLValueU512(amount));
        transferArgs.add(amountNamedArg);
        NamedArg<CLTypePublicKey> publicKeyNamedArg = new NamedArg<CLTypePublicKey>("target", new CLValuePublicKey(to));
        transferArgs.add(publicKeyNamedArg);
        CLValueOption idArg = id == null ? new CLValueOption(Optional.of(new CLValueU64())) : new CLValueOption(Optional.of(new CLValueU64(BigInteger.valueOf(id))));
        NamedArg idNamedArg = new NamedArg("id", idArg);
        transferArgs.add(idNamedArg);
        Transfer session = Transfer.builder().args(transferArgs).build();
        ModuleBytes payment = CasperDeployHelper.getPaymentModuleBytes(paymentAmount);
        return CasperDeployHelper.buildDeploy(signer, chainName, session, payment, gasPrice, ttl, date, dependencies);
    }

    private CasperTransferHelper() {
    }
}

