/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.bid;

import com.casper.sdk.annotation.ExcludeFromJacocoGeneratedReport;
import com.casper.sdk.model.key.PublicKey;
import com.casper.sdk.model.uref.URef;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;

public class JsonDelegator {
    @JsonProperty(value="bonding_purse")
    private URef bondingPurse;
    private PublicKey delegatee;
    @JsonProperty(value="public_key")
    private PublicKey publicKey;
    @JsonIgnore
    private BigInteger stakedAmount;

    @JsonProperty(value="staked_amount")
    @ExcludeFromJacocoGeneratedReport
    protected String getJsonStakedAmount() {
        return this.stakedAmount.toString(10);
    }

    @JsonProperty(value="staked_amount")
    @ExcludeFromJacocoGeneratedReport
    protected void setJsonStakedAmount(String value) {
        this.stakedAmount = new BigInteger(value, 10);
    }

    public static JsonDelegatorBuilder builder() {
        return new JsonDelegatorBuilder();
    }

    public URef getBondingPurse() {
        return this.bondingPurse;
    }

    public PublicKey getDelegatee() {
        return this.delegatee;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public BigInteger getStakedAmount() {
        return this.stakedAmount;
    }

    @JsonProperty(value="bonding_purse")
    public void setBondingPurse(URef bondingPurse) {
        this.bondingPurse = bondingPurse;
    }

    public void setDelegatee(PublicKey delegatee) {
        this.delegatee = delegatee;
    }

    @JsonProperty(value="public_key")
    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @JsonIgnore
    public void setStakedAmount(BigInteger stakedAmount) {
        this.stakedAmount = stakedAmount;
    }

    public JsonDelegator(URef bondingPurse, PublicKey delegatee, PublicKey publicKey, BigInteger stakedAmount) {
        this.bondingPurse = bondingPurse;
        this.delegatee = delegatee;
        this.publicKey = publicKey;
        this.stakedAmount = stakedAmount;
    }

    public JsonDelegator() {
    }

    public static class JsonDelegatorBuilder {
        private URef bondingPurse;
        private PublicKey delegatee;
        private PublicKey publicKey;
        private BigInteger stakedAmount;

        JsonDelegatorBuilder() {
        }

        @JsonProperty(value="bonding_purse")
        public JsonDelegatorBuilder bondingPurse(URef bondingPurse) {
            this.bondingPurse = bondingPurse;
            return this;
        }

        public JsonDelegatorBuilder delegatee(PublicKey delegatee) {
            this.delegatee = delegatee;
            return this;
        }

        @JsonProperty(value="public_key")
        public JsonDelegatorBuilder publicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @JsonIgnore
        public JsonDelegatorBuilder stakedAmount(BigInteger stakedAmount) {
            this.stakedAmount = stakedAmount;
            return this;
        }

        public JsonDelegator build() {
            return new JsonDelegator(this.bondingPurse, this.delegatee, this.publicKey, this.stakedAmount);
        }

        public String toString() {
            return "JsonDelegator.JsonDelegatorBuilder(bondingPurse=" + this.bondingPurse + ", delegatee=" + this.delegatee + ", publicKey=" + this.publicKey + ", stakedAmount=" + this.stakedAmount + ")";
        }
    }
}

