/*
 * Decompiled with CFR 0.152.
 */
package com.syntifi.crypto.key;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.util.Arrays;

public abstract class AbstractPublicKey {
    private byte[] key;

    public abstract void loadPublicKey(byte[] var1) throws IOException;

    public final void readPublicKey(String filename) throws IOException {
        try (FileReader fileReader = new FileReader(filename);){
            this.readPublicKey(fileReader);
        }
    }

    public abstract void readPublicKey(Reader var1) throws IOException;

    public final void writePublicKey(String filename) throws IOException {
        try (FileWriter fileWriter = new FileWriter(filename);){
            this.writePublicKey(fileWriter);
        }
    }

    public abstract void writePublicKey(Writer var1) throws IOException;

    public abstract Boolean verify(byte[] var1, byte[] var2) throws GeneralSecurityException;

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(byte[] key) {
        this.key = key;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractPublicKey)) {
            return false;
        }
        AbstractPublicKey other = (AbstractPublicKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getKey(), other.getKey());
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractPublicKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getKey());
        return result;
    }

    public String toString() {
        return "AbstractPublicKey(key=" + Arrays.toString(this.getKey()) + ")";
    }

    public AbstractPublicKey() {
    }

    public AbstractPublicKey(byte[] key) {
        this.key = key;
    }
}

