/*
 * Decompiled with CFR 0.152.
 */
package com.syntifi.crypto.key;

import com.syntifi.crypto.key.ASN1Identifiers;
import com.syntifi.crypto.key.AbstractPrivateKey;
import com.syntifi.crypto.key.AbstractPublicKey;
import com.syntifi.crypto.key.PemFileHelper;
import com.syntifi.crypto.key.Secp256k1PublicKey;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Sign;

public class Secp256k1PrivateKey
extends AbstractPrivateKey {
    private ECKeyPair keyPair;

    public Secp256k1PrivateKey(byte[] privateKey) throws IOException {
        super(privateKey);
        this.loadPrivateKey(privateKey);
    }

    @Override
    public void loadPrivateKey(byte[] privateKey) throws IOException {
        ASN1Sequence key = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])privateKey);
        String algoId = key.getObjectAt(2).toString();
        if (algoId.equals("[0]" + ASN1Identifiers.Secp256k1OIDCurve) && key.getObjectAt(0).toString().equals("1")) {
            DEROctetString pk = (DEROctetString)key.getObjectAt(1);
            this.keyPair = ECKeyPair.create((byte[])pk.getOctets());
            this.setKey(this.keyPair.getPrivateKey().toByteArray());
        }
    }

    @Override
    public void readPrivateKey(Reader reader) throws IOException {
        this.loadPrivateKey(PemFileHelper.readPemFile(reader));
    }

    @Override
    public void writePrivateKey(Writer writer) throws IOException {
        DERTaggedObject derPrefix = new DERTaggedObject(0, (ASN1Encodable)ASN1Identifiers.Secp256k1OIDCurve);
        DEROctetString key = new DEROctetString(this.getKey());
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)new ASN1Integer(1L));
        vector.add((ASN1Encodable)key);
        vector.add((ASN1Encodable)derPrefix);
        DERSequence derKey = new DERSequence(vector);
        PemFileHelper.writePemFile(writer, derKey.getEncoded(), "EC PRIVATE KEY");
    }

    @Override
    public byte[] sign(byte[] message) {
        Sign.SignatureData signature = Sign.signMessage((byte[])Hash.sha256((byte[])message), (ECKeyPair)this.keyPair, (boolean)false);
        ByteBuffer bb = ByteBuffer.allocate(signature.getR().length + signature.getS().length);
        bb.put(signature.getR());
        bb.put(signature.getS());
        return bb.array();
    }

    @Override
    public AbstractPublicKey derivePublicKey() {
        BigInteger pubKey = this.keyPair.getPublicKey();
        byte[] pubKeyBytes = Secp256k1PublicKey.getShortKey(pubKey.toByteArray());
        return new Secp256k1PublicKey(pubKeyBytes);
    }

    public static Secp256k1PrivateKey deriveRandomKey() {
        SecureRandom rnd = new SecureRandom();
        ECKeyPair keyPair = ECKeyPair.create((byte[])rnd.generateSeed(32));
        Secp256k1PrivateKey sk = new Secp256k1PrivateKey();
        sk.setKeyPair(keyPair);
        sk.setKey(keyPair.getPrivateKey().toByteArray());
        return sk;
    }

    public Secp256k1PrivateKey() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Secp256k1PrivateKey)) {
            return false;
        }
        Secp256k1PrivateKey other = (Secp256k1PrivateKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ECKeyPair this$keyPair = this.getKeyPair();
        ECKeyPair other$keyPair = other.getKeyPair();
        return !(this$keyPair == null ? other$keyPair != null : !this$keyPair.equals(other$keyPair));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Secp256k1PrivateKey;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ECKeyPair $keyPair = this.getKeyPair();
        result = result * 59 + ($keyPair == null ? 43 : $keyPair.hashCode());
        return result;
    }

    public ECKeyPair getKeyPair() {
        return this.keyPair;
    }

    public void setKeyPair(ECKeyPair keyPair) {
        this.keyPair = keyPair;
    }
}

