package com.casper.sdk.model.event.transaction;

import com.casper.sdk.model.entity.MessageTopic;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * Message that was emitted by an addressable entity during execution.
 *
 * @author ian@meywood.com
 */
@AllArgsConstructor
@NoArgsConstructor
@Getter
@Setter
public class Message extends MessageTopic {
    /** The identity of the entity that produced the message. */
    @JsonProperty("entity_hash")
    private String entityAddr;
    @JsonProperty("message")
    private MessagePayload<?> message;
    /** Message index in the topic. */
    @JsonProperty("topic_index")
    private int topicIndex;
    /** Message index in the block. */
    @JsonProperty("block_index")
    private long blockIndex;

    public <T extends MessagePayload<?>> T getMessage() {
        //noinspection unchecked
        return (T) message;
    }
}
