package com.casper.sdk.model.transaction.target;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.serde.Target;
import com.fasterxml.jackson.annotation.*;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.Objects;

/**
 * The execution target is a native operation (e.g. a transfer).
 * This is a placeholder for now.
 *
 * @author ian@meywood.com
 */
@JsonTypeName("Native")
@NoArgsConstructor
@Getter
@Setter
public class Native implements TransactionTarget {

    @JsonValue
    private String target = "Native";

    @JsonCreator
    public Native(final String target) {
        this.target = target;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        return o != null && getClass() == o.getClass();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(getClass().getSimpleName());
    }

    @Override
    public void serialize(final SerializerBuffer ser, final Target target) throws ValueSerializationException, NoSuchTypeException {
        ser.writeU8(getByteTag());
    }

    @Override
    @JsonIgnore
    public byte getByteTag() {
        return 0;
    }
}
