/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.helper;

import com.casper.sdk.model.common.Ttl;
import com.casper.sdk.model.deploy.NamedArg;
import com.casper.sdk.model.transaction.InitiatorAddr;
import com.casper.sdk.model.transaction.TransactionCategory;
import com.casper.sdk.model.transaction.TransactionV1;
import com.casper.sdk.model.transaction.TransactionV1Body;
import com.casper.sdk.model.transaction.TransactionV1Header;
import com.casper.sdk.model.transaction.entrypoint.TransactionEntryPoint;
import com.casper.sdk.model.transaction.pricing.PricingMode;
import com.casper.sdk.model.transaction.scheduling.TransactionScheduling;
import com.casper.sdk.model.transaction.target.TransactionTarget;
import java.util.Date;
import java.util.List;

public class TransactionHelper {
    public static TransactionV1 buildTransaction(InitiatorAddr<?> initiatorAddr, Ttl ttl, String chainName, PricingMode pricingMode, TransactionV1Body body) {
        return TransactionV1.builder().header(TransactionHelper.buildTransactionHeader(initiatorAddr, new Date(), ttl, chainName, pricingMode)).body(body).build();
    }

    private static TransactionV1Body buildTransactionBody(List<NamedArg<?>> args, TransactionTarget target, TransactionEntryPoint entryPoint, TransactionCategory category, TransactionScheduling scheduling) {
        return TransactionV1Body.builder().args(args).target(target).entryPoint(entryPoint).transactionCategory(category).scheduling(scheduling).build();
    }

    private static TransactionV1Header buildTransactionHeader(InitiatorAddr initiatorAddr, Date timestamp, Ttl ttl, String chainName, PricingMode pricingMode) {
        return TransactionV1Header.builder().initiatorAddr(initiatorAddr).timestamp(timestamp).ttl(ttl).chainName(chainName).pricingMode(pricingMode).build();
    }
}

