/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.jackson.deserializer;

import com.casper.sdk.exception.CasperClientException;
import com.casper.sdk.model.transaction.entrypoint.CustomEntryPoint;
import com.casper.sdk.model.transaction.entrypoint.TransactionEntryPoint;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Iterator;

public class TransactionEntryPointDeserializer
extends JsonDeserializer<TransactionEntryPoint> {
    public TransactionEntryPoint deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.getCurrentToken() == JsonToken.START_OBJECT) {
            return this.createNestedEntryPoint((ObjectNode)p.readValueAsTree());
        }
        if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
            return this.createSimpleEntryPoint(p.getValueAsString());
        }
        throw new IllegalArgumentException("Unknown scheduling type: " + p);
    }

    private CustomEntryPoint createNestedEntryPoint(ObjectNode objectNode) {
        Iterator stringIterator = objectNode.fieldNames();
        String next = (String)stringIterator.next();
        return new CustomEntryPoint(objectNode.get(next).asText());
    }

    private TransactionEntryPoint createSimpleEntryPoint(String name) {
        try {
            Class<?> clazz = Class.forName(this.buildClassName(name));
            return (TransactionEntryPoint)clazz.newInstance();
        }
        catch (Exception e) {
            throw new CasperClientException("Invalid TransactionEntryPoint " + name, e);
        }
    }

    private String buildClassName(String name) {
        return TransactionEntryPoint.class.getPackage().getName() + "." + name + "EntryPoint";
    }
}

