/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.jackson.deserializer;

import com.casper.sdk.model.transaction.scheduling.FutureEra;
import com.casper.sdk.model.transaction.scheduling.FutureTimestamp;
import com.casper.sdk.model.transaction.scheduling.Standard;
import com.casper.sdk.model.transaction.scheduling.TransactionScheduling;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;

public class TransactionSchedulingDeserializer
extends JsonDeserializer<TransactionScheduling> {
    public TransactionScheduling deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.getCurrentToken() == JsonToken.START_OBJECT) {
            ObjectNode treeNode = (ObjectNode)p.readValueAsTree();
            Iterator stringIterator = treeNode.fieldNames();
            String next = (String)stringIterator.next();
            if (next.equals(FutureTimestamp.class.getSimpleName())) {
                return new FutureTimestamp(treeNode.get(next).asText());
            }
            if (next.equals(FutureEra.class.getSimpleName())) {
                return new FutureEra(new BigInteger(treeNode.get(next).asText()));
            }
            throw new IllegalArgumentException("Unknown scheduling type: " + next);
        }
        if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
            return new Standard();
        }
        throw new IllegalArgumentException("Unknown scheduling type: " + p);
    }
}

