/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.account;

import com.casper.sdk.model.account.Account;
import com.fasterxml.jackson.annotation.JsonProperty;

public class AccountData {
    @JsonProperty(value="api_version")
    private String apiVersion;
    private Account account;
    @JsonProperty(value="merkle_proof")
    private String merkelProof;

    public static AccountDataBuilder builder() {
        return new AccountDataBuilder();
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public Account getAccount() {
        return this.account;
    }

    public String getMerkelProof() {
        return this.merkelProof;
    }

    @JsonProperty(value="api_version")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    @JsonProperty(value="merkle_proof")
    public void setMerkelProof(String merkelProof) {
        this.merkelProof = merkelProof;
    }

    public AccountData() {
    }

    public AccountData(String apiVersion, Account account, String merkelProof) {
        this.apiVersion = apiVersion;
        this.account = account;
        this.merkelProof = merkelProof;
    }

    public static class AccountDataBuilder {
        private String apiVersion;
        private Account account;
        private String merkelProof;

        AccountDataBuilder() {
        }

        @JsonProperty(value="api_version")
        public AccountDataBuilder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public AccountDataBuilder account(Account account) {
            this.account = account;
            return this;
        }

        @JsonProperty(value="merkle_proof")
        public AccountDataBuilder merkelProof(String merkelProof) {
            this.merkelProof = merkelProof;
            return this;
        }

        public AccountData build() {
            return new AccountData(this.apiVersion, this.account, this.merkelProof);
        }

        public String toString() {
            return "AccountData.AccountDataBuilder(apiVersion=" + this.apiVersion + ", account=" + this.account + ", merkelProof=" + this.merkelProof + ")";
        }
    }
}

