/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.bid;

import com.casper.sdk.annotation.ExcludeFromJacocoGeneratedReport;
import com.casper.sdk.model.bid.VestingSchedule;
import com.casper.sdk.model.key.PublicKey;
import com.casper.sdk.model.uref.URef;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;

public class JsonDelegator {
    @JsonProperty(value="bonding_purse")
    private URef bondingPurse;
    @JsonProperty(value="validator_public_key")
    private PublicKey validatorPublicKey;
    @JsonProperty(value="delegator_public_key")
    private PublicKey delegatorPublicKey;
    @JsonProperty(value="vesting_schedule")
    private VestingSchedule vestingSchedule;
    @JsonIgnore
    private BigInteger stakedAmount;

    @JsonProperty(value="staked_amount")
    @ExcludeFromJacocoGeneratedReport
    protected String getJsonStakedAmount() {
        return this.stakedAmount.toString(10);
    }

    @JsonProperty(value="staked_amount")
    @ExcludeFromJacocoGeneratedReport
    protected void setJsonStakedAmount(String value) {
        this.stakedAmount = new BigInteger(value, 10);
    }

    public static JsonDelegatorBuilder builder() {
        return new JsonDelegatorBuilder();
    }

    public URef getBondingPurse() {
        return this.bondingPurse;
    }

    public PublicKey getValidatorPublicKey() {
        return this.validatorPublicKey;
    }

    public PublicKey getDelegatorPublicKey() {
        return this.delegatorPublicKey;
    }

    public VestingSchedule getVestingSchedule() {
        return this.vestingSchedule;
    }

    public BigInteger getStakedAmount() {
        return this.stakedAmount;
    }

    @JsonProperty(value="bonding_purse")
    public void setBondingPurse(URef bondingPurse) {
        this.bondingPurse = bondingPurse;
    }

    @JsonProperty(value="validator_public_key")
    public void setValidatorPublicKey(PublicKey validatorPublicKey) {
        this.validatorPublicKey = validatorPublicKey;
    }

    @JsonProperty(value="delegator_public_key")
    public void setDelegatorPublicKey(PublicKey delegatorPublicKey) {
        this.delegatorPublicKey = delegatorPublicKey;
    }

    @JsonProperty(value="vesting_schedule")
    public void setVestingSchedule(VestingSchedule vestingSchedule) {
        this.vestingSchedule = vestingSchedule;
    }

    @JsonIgnore
    public void setStakedAmount(BigInteger stakedAmount) {
        this.stakedAmount = stakedAmount;
    }

    public JsonDelegator(URef bondingPurse, PublicKey validatorPublicKey, PublicKey delegatorPublicKey, VestingSchedule vestingSchedule, BigInteger stakedAmount) {
        this.bondingPurse = bondingPurse;
        this.validatorPublicKey = validatorPublicKey;
        this.delegatorPublicKey = delegatorPublicKey;
        this.vestingSchedule = vestingSchedule;
        this.stakedAmount = stakedAmount;
    }

    public JsonDelegator() {
    }

    public static class JsonDelegatorBuilder {
        private URef bondingPurse;
        private PublicKey validatorPublicKey;
        private PublicKey delegatorPublicKey;
        private VestingSchedule vestingSchedule;
        private BigInteger stakedAmount;

        JsonDelegatorBuilder() {
        }

        @JsonProperty(value="bonding_purse")
        public JsonDelegatorBuilder bondingPurse(URef bondingPurse) {
            this.bondingPurse = bondingPurse;
            return this;
        }

        @JsonProperty(value="validator_public_key")
        public JsonDelegatorBuilder validatorPublicKey(PublicKey validatorPublicKey) {
            this.validatorPublicKey = validatorPublicKey;
            return this;
        }

        @JsonProperty(value="delegator_public_key")
        public JsonDelegatorBuilder delegatorPublicKey(PublicKey delegatorPublicKey) {
            this.delegatorPublicKey = delegatorPublicKey;
            return this;
        }

        @JsonProperty(value="vesting_schedule")
        public JsonDelegatorBuilder vestingSchedule(VestingSchedule vestingSchedule) {
            this.vestingSchedule = vestingSchedule;
            return this;
        }

        @JsonIgnore
        public JsonDelegatorBuilder stakedAmount(BigInteger stakedAmount) {
            this.stakedAmount = stakedAmount;
            return this;
        }

        public JsonDelegator build() {
            return new JsonDelegator(this.bondingPurse, this.validatorPublicKey, this.delegatorPublicKey, this.vestingSchedule, this.stakedAmount);
        }

        public String toString() {
            return "JsonDelegator.JsonDelegatorBuilder(bondingPurse=" + this.bondingPurse + ", validatorPublicKey=" + this.validatorPublicKey + ", delegatorPublicKey=" + this.delegatorPublicKey + ", vestingSchedule=" + this.vestingSchedule + ", stakedAmount=" + this.stakedAmount + ")";
        }
    }
}

