/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.block;

import com.casper.sdk.model.block.BlockBody;
import com.casper.sdk.model.common.Digest;
import com.casper.sdk.model.transaction.TransactionCategory;
import com.casper.sdk.model.transaction.TransactionHash;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BlockBodyV2
extends BlockBody {
    @JsonProperty(value="hash")
    private Digest hash;
    @JsonProperty(value="transfer_hashes")
    private List<Digest> transferHashes;
    @JsonProperty(value="rewarded_signatures")
    private List<List<Long>> rewardedSignatures;
    @JsonProperty(value="transactions")
    private Map<TransactionCategory, List<TransactionHash>> transactions;

    public List<List<Long>> getRewardedSignatures() {
        return this.rewardedSignatures != null ? this.rewardedSignatures : Collections.emptyList();
    }

    public List<Digest> getTransferHashes() {
        return this.transferHashes != null ? this.transferHashes : Collections.emptyList();
    }

    @JsonIgnore
    public List<Digest> getFlatTransactions() {
        return this.transactions.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static BlockBodyV2Builder builder() {
        return new BlockBodyV2Builder();
    }

    public Digest getHash() {
        return this.hash;
    }

    public Map<TransactionCategory, List<TransactionHash>> getTransactions() {
        return this.transactions;
    }

    @JsonProperty(value="hash")
    public void setHash(Digest hash) {
        this.hash = hash;
    }

    @JsonProperty(value="transfer_hashes")
    public void setTransferHashes(List<Digest> transferHashes) {
        this.transferHashes = transferHashes;
    }

    @JsonProperty(value="rewarded_signatures")
    public void setRewardedSignatures(List<List<Long>> rewardedSignatures) {
        this.rewardedSignatures = rewardedSignatures;
    }

    @JsonProperty(value="transactions")
    public void setTransactions(Map<TransactionCategory, List<TransactionHash>> transactions) {
        this.transactions = transactions;
    }

    public BlockBodyV2(Digest hash, List<Digest> transferHashes, List<List<Long>> rewardedSignatures, Map<TransactionCategory, List<TransactionHash>> transactions) {
        this.hash = hash;
        this.transferHashes = transferHashes;
        this.rewardedSignatures = rewardedSignatures;
        this.transactions = transactions;
    }

    public BlockBodyV2() {
    }

    public static class BlockBodyV2Builder {
        private Digest hash;
        private List<Digest> transferHashes;
        private List<List<Long>> rewardedSignatures;
        private Map<TransactionCategory, List<TransactionHash>> transactions;

        BlockBodyV2Builder() {
        }

        @JsonProperty(value="hash")
        public BlockBodyV2Builder hash(Digest hash) {
            this.hash = hash;
            return this;
        }

        @JsonProperty(value="transfer_hashes")
        public BlockBodyV2Builder transferHashes(List<Digest> transferHashes) {
            this.transferHashes = transferHashes;
            return this;
        }

        @JsonProperty(value="rewarded_signatures")
        public BlockBodyV2Builder rewardedSignatures(List<List<Long>> rewardedSignatures) {
            this.rewardedSignatures = rewardedSignatures;
            return this;
        }

        @JsonProperty(value="transactions")
        public BlockBodyV2Builder transactions(Map<TransactionCategory, List<TransactionHash>> transactions) {
            this.transactions = transactions;
            return this;
        }

        public BlockBodyV2 build() {
            return new BlockBodyV2(this.hash, this.transferHashes, this.rewardedSignatures, this.transactions);
        }

        public String toString() {
            return "BlockBodyV2.BlockBodyV2Builder(hash=" + this.hash + ", transferHashes=" + this.transferHashes + ", rewardedSignatures=" + this.rewardedSignatures + ", transactions=" + this.transactions + ")";
        }
    }
}

