/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.block;

import com.casper.sdk.model.block.BlockHeader;
import com.casper.sdk.model.common.Digest;
import com.casper.sdk.model.era.EraEndV2;
import com.fasterxml.jackson.annotation.JsonProperty;

public class BlockHeaderV2
extends BlockHeader {
    @JsonProperty(value="era_end")
    private EraEndV2 eraEnd;
    @JsonProperty(value="proposer")
    private Digest proposer;
    @JsonProperty(value="current_gas_price")
    private long currentGasPrice;
    @JsonProperty(value="last_switch_block_hash")
    private Digest lastSwitchBlockHash;

    public static BlockHeaderV2Builder builder() {
        return new BlockHeaderV2Builder();
    }

    public EraEndV2 getEraEnd() {
        return this.eraEnd;
    }

    public Digest getProposer() {
        return this.proposer;
    }

    public long getCurrentGasPrice() {
        return this.currentGasPrice;
    }

    public Digest getLastSwitchBlockHash() {
        return this.lastSwitchBlockHash;
    }

    @JsonProperty(value="era_end")
    public void setEraEnd(EraEndV2 eraEnd) {
        this.eraEnd = eraEnd;
    }

    @JsonProperty(value="proposer")
    public void setProposer(Digest proposer) {
        this.proposer = proposer;
    }

    @JsonProperty(value="current_gas_price")
    public void setCurrentGasPrice(long currentGasPrice) {
        this.currentGasPrice = currentGasPrice;
    }

    @JsonProperty(value="last_switch_block_hash")
    public void setLastSwitchBlockHash(Digest lastSwitchBlockHash) {
        this.lastSwitchBlockHash = lastSwitchBlockHash;
    }

    public BlockHeaderV2(EraEndV2 eraEnd, Digest proposer, long currentGasPrice, Digest lastSwitchBlockHash) {
        this.eraEnd = eraEnd;
        this.proposer = proposer;
        this.currentGasPrice = currentGasPrice;
        this.lastSwitchBlockHash = lastSwitchBlockHash;
    }

    public BlockHeaderV2() {
    }

    public static class BlockHeaderV2Builder {
        private EraEndV2 eraEnd;
        private Digest proposer;
        private long currentGasPrice;
        private Digest lastSwitchBlockHash;

        BlockHeaderV2Builder() {
        }

        @JsonProperty(value="era_end")
        public BlockHeaderV2Builder eraEnd(EraEndV2 eraEnd) {
            this.eraEnd = eraEnd;
            return this;
        }

        @JsonProperty(value="proposer")
        public BlockHeaderV2Builder proposer(Digest proposer) {
            this.proposer = proposer;
            return this;
        }

        @JsonProperty(value="current_gas_price")
        public BlockHeaderV2Builder currentGasPrice(long currentGasPrice) {
            this.currentGasPrice = currentGasPrice;
            return this;
        }

        @JsonProperty(value="last_switch_block_hash")
        public BlockHeaderV2Builder lastSwitchBlockHash(Digest lastSwitchBlockHash) {
            this.lastSwitchBlockHash = lastSwitchBlockHash;
            return this;
        }

        public BlockHeaderV2 build() {
            return new BlockHeaderV2(this.eraEnd, this.proposer, this.currentGasPrice, this.lastSwitchBlockHash);
        }

        public String toString() {
            return "BlockHeaderV2.BlockHeaderV2Builder(eraEnd=" + this.eraEnd + ", proposer=" + this.proposer + ", currentGasPrice=" + this.currentGasPrice + ", lastSwitchBlockHash=" + this.lastSwitchBlockHash + ")";
        }
    }
}

