/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.clvalue;

import com.casper.sdk.model.clvalue.AbstractCLValue;
import com.casper.sdk.model.clvalue.AbstractCLValueWithChildren;
import com.casper.sdk.model.clvalue.CLValueBool;
import com.casper.sdk.model.clvalue.cltype.AbstractCLType;
import com.casper.sdk.model.clvalue.cltype.AbstractCLTypeWithChildren;
import com.casper.sdk.model.clvalue.cltype.CLTypeData;
import com.casper.sdk.model.clvalue.cltype.CLTypeOption;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.oak3.sbs4j.DeserializerBuffer;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.util.Optional;
import org.bouncycastle.util.encoders.Hex;

public class CLValueOption
extends AbstractCLValueWithChildren<Optional<AbstractCLValue<?, ?>>, CLTypeOption> {
    @JsonProperty(value="cl_type")
    private CLTypeOption clType = new CLTypeOption();

    @JsonCreator
    public CLValueOption(@JsonProperty(value="cl_type") CLTypeOption clType, @JsonProperty(value="bytes") String bytes, @JsonProperty(value="parsed") Object parsed) {
        this.setBytes(bytes);
        this.setClType(clType);
        this.setParsed(parsed);
    }

    @Override
    public void setClType(CLTypeOption clType) {
        this.clType = clType;
        this.childTypesSet();
    }

    public CLValueOption(Optional<AbstractCLValue<?, ?>> value) throws ValueSerializationException {
        this.setChildTypes(value);
        this.setValue(value);
        this.setParsed(value.map(AbstractCLValue::getParsed).orElse(null));
    }

    @Override
    protected void serializeValue(SerializerBuffer ser) throws ValueSerializationException {
        SerializerBuffer serVal = new SerializerBuffer();
        Optional value = (Optional)this.getValue();
        CLValueBool isPresent = new CLValueBool(value.isPresent() && ((AbstractCLValue)value.get()).getValue() != null);
        isPresent.serialize(serVal);
        if (value.isPresent() && ((AbstractCLValue)value.get()).getClType() instanceof AbstractCLTypeWithChildren) {
            ((AbstractCLTypeWithChildren)((AbstractCLValue)value.get()).getClType()).setChildTypes(((AbstractCLTypeWithChildren)this.clType.getOptionType()).getChildTypes());
        }
        if (Boolean.TRUE.equals(isPresent.getValue()) && value.isPresent()) {
            ((AbstractCLValue)value.get()).serialize(serVal);
        }
        byte[] bytes = serVal.toByteArray();
        ser.writeByteArray(bytes);
        this.setBytes(Hex.toHexString((byte[])bytes));
    }

    @Override
    public void deserializeCustom(DeserializerBuffer deser) throws Exception {
        CLValueBool isPresent = new CLValueBool();
        isPresent.deserializeCustom(deser);
        CLTypeData childTypeData = this.clType.getOptionType().getClTypeData();
        AbstractCLValue<?, ?> child = CLTypeData.createCLValueFromCLTypeData(childTypeData);
        this.populateChildTypesFromParent(child, this.clType.getOptionType());
        if (Boolean.TRUE.equals(isPresent.getValue())) {
            child.deserializeCustom(deser);
        }
        this.setValue(Optional.of(child));
    }

    @Override
    protected void setChildTypes(Optional<AbstractCLValue<?, ?>> value) {
        if (value.isPresent()) {
            this.clType.setOptionType((AbstractCLType)value.get().getClType());
        } else {
            this.clType.setChildTypes(null);
        }
    }

    public String toString() {
        return this.getValue() != null && ((Optional)this.getValue()).isPresent() && ((AbstractCLValue)((Optional)this.getValue()).get()).getValue() != null ? ((AbstractCLValue)((Optional)this.getValue()).get()).toString() : "None";
    }

    @Override
    public CLTypeOption getClType() {
        return this.clType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CLValueOption)) {
            return false;
        }
        CLValueOption other = (CLValueOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CLTypeOption this$clType = this.getClType();
        CLTypeOption other$clType = other.getClType();
        return !(this$clType == null ? other$clType != null : !((Object)this$clType).equals(other$clType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CLValueOption;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CLTypeOption $clType = this.getClType();
        result = result * 59 + ($clType == null ? 43 : ((Object)$clType).hashCode());
        return result;
    }

    public CLValueOption() {
    }
}

