/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.deploy;

import com.casper.sdk.exception.CasperClientException;
import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.serde.CasperSerializableObject;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.common.Digest;
import com.casper.sdk.model.deploy.Approval;
import com.casper.sdk.model.deploy.DeployHeader;
import com.casper.sdk.model.deploy.executabledeploy.ExecutableDeployItem;
import com.casper.sdk.model.transaction.AbstractTransaction;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.util.List;

@JsonPropertyOrder(value={"hash", "header", "payment", "session", "approvals"})
public class Deploy
extends AbstractTransaction
implements CasperSerializableObject {
    private DeployHeader header;
    private ExecutableDeployItem payment;
    private ExecutableDeployItem session;

    public Deploy(Digest hash, DeployHeader header, ExecutableDeployItem payment, ExecutableDeployItem session, List<Approval> approvals) {
        super(hash, approvals);
        this.header = header;
        this.payment = payment;
        this.session = session;
    }

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws NoSuchTypeException, ValueSerializationException {
        this.header.serialize(ser, Target.BYTE);
        this.getHash().serialize(ser, Target.BYTE);
        this.payment.serialize(ser, Target.BYTE);
        this.session.serialize(ser, Target.BYTE);
        this.serializeApprovals(ser, Target.BYTE);
    }

    @Override
    protected void calculateHash() {
        try {
            this.header.setBodyHash(this.calculateSessionAndPaymentHash());
            this.setHash(this.header.buildHash());
        }
        catch (Exception e) {
            throw new CasperClientException("Error calculation header hash", e);
        }
    }

    protected Digest calculateSessionAndPaymentHash() {
        try {
            SerializerBuffer ser = new SerializerBuffer();
            this.payment.serialize(ser, Target.BYTE);
            this.session.serialize(ser, Target.BYTE);
            return Digest.blake2bDigestFromBytes(ser.toByteArray());
        }
        catch (Exception e) {
            throw new CasperClientException("Error calculation session and payment hash", e);
        }
    }

    public static DeployBuilder builder() {
        return new DeployBuilder();
    }

    public DeployHeader getHeader() {
        return this.header;
    }

    public ExecutableDeployItem getPayment() {
        return this.payment;
    }

    public ExecutableDeployItem getSession() {
        return this.session;
    }

    public void setHeader(DeployHeader header) {
        this.header = header;
    }

    public void setPayment(ExecutableDeployItem payment) {
        this.payment = payment;
    }

    public void setSession(ExecutableDeployItem session) {
        this.session = session;
    }

    public Deploy(DeployHeader header, ExecutableDeployItem payment, ExecutableDeployItem session) {
        this.header = header;
        this.payment = payment;
        this.session = session;
    }

    public Deploy() {
    }

    public static class DeployBuilder {
        private DeployHeader header;
        private ExecutableDeployItem payment;
        private ExecutableDeployItem session;
        private Digest hash;
        private List<Approval> approvals;

        DeployBuilder() {
        }

        public DeployBuilder header(DeployHeader header) {
            this.header = header;
            return this;
        }

        public DeployBuilder payment(ExecutableDeployItem payment) {
            this.payment = payment;
            return this;
        }

        public DeployBuilder session(ExecutableDeployItem session) {
            this.session = session;
            return this;
        }

        public Deploy build() {
            return new Deploy(this.header, this.payment, this.session);
        }

        public String toString() {
            return "Deploy.DeployBuilder(header=" + this.header + ", payment=" + this.payment + ", session=" + this.session + ")";
        }

        public DeployBuilder hash(Digest hash) {
            this.hash = hash;
            return this;
        }

        public DeployBuilder approvals(List<Approval> approvals) {
            this.approvals = approvals;
            return this;
        }
    }
}

