/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.key;

import com.casper.sdk.exception.NoSuchKeyTagException;
import com.casper.sdk.model.entity.EntityAddr;
import com.casper.sdk.model.key.Key;
import com.casper.sdk.model.key.KeyTag;
import com.fasterxml.jackson.annotation.JsonValue;
import com.syntifi.crypto.key.encdec.Hex;
import dev.oak3.sbs4j.DeserializerBuffer;
import dev.oak3.sbs4j.util.ByteUtils;

public class AddressableEntityKey
extends Key {
    private EntityAddr entityAddressTag;

    @Override
    protected void fromStringCustom(String strKey) {
        try {
            String[] split = strKey.split("-");
            this.entityAddressTag = EntityAddr.getByKeyName(split[1]);
            byte[] key = new byte[33];
            key[0] = this.entityAddressTag.getByteTag();
            System.arraycopy(Hex.decode(split[split.length - 1]), 0, key, 1, 32);
            this.setKey(key);
        }
        catch (NoSuchKeyTagException e) {
            throw new IllegalArgumentException("Invalid key: " + strKey, e);
        }
    }

    @Override
    protected void deserializeCustom(DeserializerBuffer deser) throws Exception {
        this.setTag(KeyTag.ADDRESSABLE_ENTITY);
        this.setKey(deser.readByteArray(33));
        this.entityAddressTag = EntityAddr.getByTag(this.getKey()[0]);
    }

    @Override
    public String toString() {
        return ((KeyTag)this.getTag()).getKeyName() + this.entityAddressTag.getKeyName() + "-" + Hex.encode(this.getKey()).substring(2);
    }

    @Override
    @JsonValue
    public String getAlgoTaggedHex() {
        return ByteUtils.encodeHexString((byte[])new byte[]{((KeyTag)this.getTag()).getByteTag()}) + ByteUtils.encodeHexString((byte[])this.getKey());
    }

    public AddressableEntityKey(EntityAddr entityAddressTag) {
        this.entityAddressTag = entityAddressTag;
    }

    public AddressableEntityKey() {
    }

    public EntityAddr getEntityAddressTag() {
        return this.entityAddressTag;
    }
}

