/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.key;

import com.casper.sdk.model.key.Tag;

public enum BlockGlobalAddr implements Tag
{
    BLOCK_TIME(0, "time"),
    MESSAGE_COUNT(1, "message-count");

    private final byte byteTag;
    private final String keyName;

    public static BlockGlobalAddr getByTag(byte byteTag) {
        for (BlockGlobalAddr addr : BlockGlobalAddr.values()) {
            if (addr.byteTag != byteTag) continue;
            return addr;
        }
        throw new IllegalArgumentException("No such BlockGlobalAddr: " + byteTag);
    }

    public static BlockGlobalAddr getByKeyName(String keyName) {
        for (BlockGlobalAddr addr : BlockGlobalAddr.values()) {
            if (!keyName.contains(addr.keyName)) continue;
            return addr;
        }
        throw new IllegalArgumentException("No such BlockGlobalAddr: " + keyName);
    }

    private BlockGlobalAddr(byte byteTag, String keyName) {
        this.byteTag = byteTag;
        this.keyName = keyName;
    }

    @Override
    public byte getByteTag() {
        return this.byteTag;
    }

    public String getKeyName() {
        return this.keyName;
    }
}

