/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.key;

import com.casper.sdk.exception.NoSuchKeyTagException;

public enum ByteCodeAddr {
    V1_CASPER_WASM(0, "v1-wasm"),
    EMPTY(1, "empty");

    private final byte byteTag;
    private final String keyName;

    public static ByteCodeAddr getByTag(byte tag) throws NoSuchKeyTagException {
        for (ByteCodeAddr a : ByteCodeAddr.values()) {
            if (a.byteTag != tag) continue;
            return a;
        }
        throw new NoSuchKeyTagException();
    }

    public static ByteCodeAddr getByKeyName(String keyName) {
        for (ByteCodeAddr entityAddr : ByteCodeAddr.values()) {
            if (!keyName.contains(entityAddr.keyName)) continue;
            return entityAddr;
        }
        throw new IllegalArgumentException("No such key name: " + keyName);
    }

    private ByteCodeAddr(byte byteTag, String keyName) {
        this.byteTag = byteTag;
        this.keyName = keyName;
    }

    public byte getByteTag() {
        return this.byteTag;
    }

    public String getKeyName() {
        return this.keyName;
    }
}

