/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.key;

import com.casper.sdk.model.key.ByteCodeAddr;
import com.casper.sdk.model.key.Key;
import com.casper.sdk.model.key.KeyTag;
import com.fasterxml.jackson.annotation.JsonValue;
import com.syntifi.crypto.key.encdec.Hex;
import dev.oak3.sbs4j.DeserializerBuffer;
import dev.oak3.sbs4j.util.ByteUtils;

public class ByteCodeKey
extends Key {
    private ByteCodeAddr byteCodeAddr;

    @Override
    @JsonValue
    public String getAlgoTaggedHex() {
        return ByteUtils.encodeHexString((byte[])new byte[]{((KeyTag)this.getTag()).getByteTag()}) + ByteUtils.encodeHexString((byte[])this.getKey());
    }

    @Override
    protected void fromStringCustom(String strKey) {
        this.byteCodeAddr = ByteCodeAddr.getByKeyName(strKey);
        byte[] key = new byte[33];
        String[] split = strKey.split("-");
        key[0] = this.byteCodeAddr.getByteTag();
        System.arraycopy(Hex.decode(split[split.length - 1]), 0, key, 1, 32);
        this.setKey(key);
    }

    @Override
    public String toString() {
        return ((KeyTag)this.getTag()).getKeyName() + this.byteCodeAddr.getKeyName() + "-" + Hex.encode(this.getKey()).substring(2);
    }

    @Override
    protected void deserializeCustom(DeserializerBuffer deser) throws Exception {
        this.setKey(deser.readByteArray(33));
        this.byteCodeAddr = ByteCodeAddr.getByTag(this.getKey()[0]);
    }

    public ByteCodeKey(ByteCodeAddr byteCodeAddr) {
        this.byteCodeAddr = byteCodeAddr;
    }

    public ByteCodeKey() {
    }

    public ByteCodeAddr getByteCodeAddr() {
        return this.byteCodeAddr;
    }
}

