/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.key;

import com.casper.sdk.exception.NoSuchKeyTagException;
import com.casper.sdk.model.entity.EntityAddr;
import com.casper.sdk.model.key.EntryPointAddr;
import com.casper.sdk.model.key.Key;
import com.casper.sdk.model.key.KeyTag;
import com.syntifi.crypto.key.encdec.Hex;
import dev.oak3.sbs4j.DeserializerBuffer;
import dev.oak3.sbs4j.SerializerBuffer;

public class EntryPointKey
extends Key {
    private EntryPointAddr entryPointAddr;
    private EntityAddr entityAddr;
    private byte[] hashAddr;
    private byte[] namedBytes;
    private long selector;

    @Override
    protected void fromStringCustom(String strKey) {
        String[] split = strKey.split("-");
        try {
            this.entryPointAddr = EntryPointAddr.getByKeyName(split[2]);
            this.entityAddr = EntityAddr.getByKeyName(split[4]);
        }
        catch (NoSuchKeyTagException e) {
            throw new IllegalArgumentException("Invalid key: " + strKey);
        }
        this.hashAddr = Hex.decode(split[5]);
        if (this.entryPointAddr == EntryPointAddr.VM_CASPER_V1) {
            this.namedBytes = Hex.decode(split[6]);
        } else if (this.entryPointAddr == EntryPointAddr.VM_CASPER_V2) {
            this.selector = Long.parseLong(split[6]);
        } else {
            throw new IllegalArgumentException("Invalid key: " + strKey);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(((KeyTag)this.getTag()).getKeyName());
        if (this.entryPointAddr == EntryPointAddr.VM_CASPER_V2) {
            sb.append("v2");
        } else {
            sb.append("v1");
        }
        sb.append("-entity-").append(this.entityAddr.getKeyName()).append('-').append(Hex.encode(this.hashAddr)).append('-');
        if (this.entryPointAddr == EntryPointAddr.VM_CASPER_V2) {
            sb.append(this.selector);
        } else {
            sb.append(Hex.encode(this.namedBytes));
        }
        this.refreshKey();
        return sb.toString();
    }

    @Override
    protected void deserializeCustom(DeserializerBuffer deser) throws Exception {
        this.entryPointAddr = EntryPointAddr.getByTag(deser.readU8());
        this.entityAddr = EntityAddr.getByTag(deser.readU8());
        this.hashAddr = deser.readByteArray(32);
        if (this.entryPointAddr == EntryPointAddr.VM_CASPER_V1) {
            this.namedBytes = deser.readByteArray(32);
        } else {
            this.selector = deser.readU32();
        }
        this.refreshKey();
    }

    private void refreshKey() {
        SerializerBuffer ser = new SerializerBuffer();
        ser.writeU8(this.entryPointAddr.getByteTag());
        ser.writeU8(this.entityAddr.getByteTag());
        ser.writeByteArray(this.hashAddr);
        if (this.entryPointAddr == EntryPointAddr.VM_CASPER_V1) {
            ser.writeByteArray(this.namedBytes);
        } else {
            ser.writeU32(Long.valueOf(this.selector));
        }
        this.setKey(ser.toByteArray());
    }

    public EntryPointKey(EntryPointAddr entryPointAddr, EntityAddr entityAddr, byte[] hashAddr, byte[] namedBytes, long selector) {
        this.entryPointAddr = entryPointAddr;
        this.entityAddr = entityAddr;
        this.hashAddr = hashAddr;
        this.namedBytes = namedBytes;
        this.selector = selector;
    }

    public EntryPointKey() {
    }

    public EntryPointAddr getEntryPointAddr() {
        return this.entryPointAddr;
    }

    public EntityAddr getEntityAddr() {
        return this.entityAddr;
    }

    public byte[] getHashAddr() {
        return this.hashAddr;
    }

    public byte[] getNamedBytes() {
        return this.namedBytes;
    }

    public long getSelector() {
        return this.selector;
    }

    public void setEntryPointAddr(EntryPointAddr entryPointAddr) {
        this.entryPointAddr = entryPointAddr;
    }

    public void setEntityAddr(EntityAddr entityAddr) {
        this.entityAddr = entityAddr;
    }

    public void setHashAddr(byte[] hashAddr) {
        this.hashAddr = hashAddr;
    }

    public void setNamedBytes(byte[] namedBytes) {
        this.namedBytes = namedBytes;
    }

    public void setSelector(long selector) {
        this.selector = selector;
    }
}

