/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.key;

import com.casper.sdk.model.key.Key;
import com.casper.sdk.model.key.KeyTag;
import dev.oak3.sbs4j.DeserializerBuffer;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.math.BigInteger;

public class EraInfoKey
extends Key {
    private BigInteger eraId;

    @Override
    protected void deserializeCustom(DeserializerBuffer deser) throws Exception {
        this.eraId = deser.readU64();
        this.refreshKey();
    }

    @Override
    protected void fromStringCustom(String strKey) {
        try {
            String[] split = strKey.split("-");
            this.eraId = new BigInteger(split[split.length - 1]);
            this.refreshKey();
        }
        catch (ValueSerializationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String toString() {
        return ((KeyTag)this.getTag()).getKeyName() + this.eraId;
    }

    private void refreshKey() throws ValueSerializationException {
        SerializerBuffer ser = new SerializerBuffer();
        ser.writeU64(this.eraId);
        this.setKey(ser.toByteArray());
    }

    public EraInfoKey(BigInteger eraId) {
        this.eraId = eraId;
    }

    public EraInfoKey() {
    }

    public BigInteger getEraId() {
        return this.eraId;
    }

    public void setEraId(BigInteger eraId) {
        this.eraId = eraId;
    }
}

