/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.key;

import com.casper.sdk.exception.NoSuchKeyTagException;
import com.casper.sdk.model.key.AddressableEntityKey;
import com.casper.sdk.model.key.BalanceHoldKey;
import com.casper.sdk.model.key.BidAddrKey;
import com.casper.sdk.model.key.BlockGlobalKey;
import com.casper.sdk.model.key.ByteCodeKey;
import com.casper.sdk.model.key.EntryPointKey;
import com.casper.sdk.model.key.EraInfoKey;
import com.casper.sdk.model.key.Key;
import com.casper.sdk.model.key.MessageKey;
import com.casper.sdk.model.key.NamedKeyKey;
import com.casper.sdk.model.key.Tag;
import com.casper.sdk.model.key.URefKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum KeyTag implements Tag
{
    ACCOUNT(0, Key.class, "account-hash-"),
    HASH(1, Key.class, "hash-", "contract-"),
    UREF(2, URefKey.class, "uref-"),
    TRANSFER(3, Key.class, "transfer-"),
    DEPLOY_INFO(4, Key.class, "deploy-"),
    ERA_INFO(5, EraInfoKey.class, "era-"),
    BALANCE(6, Key.class, "balance-"),
    BID(7, Key.class, "bid-"),
    WITHDRAW(8, Key.class, "withdraw-"),
    DICTIONARY(9, Key.class, "dictionary-"),
    SYSTEM_ENTITY_REGISTRY(10, Key.class, "system-contract-registry-"),
    ERA_SUMMARY(11, Key.class, "era-summary-"),
    UNBOND(12, Key.class, "unbond-"),
    CHAINSPEC_REGISTRY(13, Key.class, "chainspec-registry-"),
    CHECKSUM_REGISTRY(14, Key.class, "checksum-registry-"),
    BID_ADDR(15, BidAddrKey.class, "bid-addr-"),
    PACKAGE(16, Key.class, "package-"),
    ADDRESSABLE_ENTITY(17, AddressableEntityKey.class, "entity-"),
    BYTE_CODE(18, ByteCodeKey.class, "byte-code-"),
    MESSAGE(19, MessageKey.class, "message-"),
    NAMED_KEY(20, NamedKeyKey.class, "named-key-"),
    BLOCK_GLOBAL(21, BlockGlobalKey.class, "block-"),
    ENTRY_POINT(23, EntryPointKey.class, "entry-point-"),
    BALANCE_HOLD(22, BalanceHoldKey.class, "balance-hold-");

    private final byte byteTag;
    private final Class<? extends Key> keyClass;
    private final String[] keyNames;
    private static final List<KeyTag> reversed;

    private KeyTag(byte byteTag, Class<? extends Key> keyClass, String ... keyNames) {
        this.byteTag = byteTag;
        this.keyClass = keyClass;
        this.keyNames = keyNames;
    }

    public static KeyTag getByTag(byte tag) throws NoSuchKeyTagException {
        for (KeyTag a : KeyTag.values()) {
            if (a.byteTag != tag) continue;
            return a;
        }
        throw new NoSuchKeyTagException("No such tag: " + tag);
    }

    public static KeyTag getByKeyName(String keyName) throws NoSuchKeyTagException {
        for (KeyTag a : reversed) {
            for (String name : a.keyNames) {
                if (!keyName.startsWith(name)) continue;
                return a;
            }
        }
        throw new NoSuchKeyTagException("No such key name: " + keyName);
    }

    private static List<KeyTag> reversed() {
        List<KeyTag> reversed = Arrays.asList(KeyTag.values());
        Collections.reverse(reversed);
        return reversed;
    }

    public String getKeyName() {
        return this.keyNames[0];
    }

    @Override
    public byte getByteTag() {
        return this.byteTag;
    }

    public Class<? extends Key> getKeyClass() {
        return this.keyClass;
    }

    public String[] getKeyNames() {
        return this.keyNames;
    }

    static {
        reversed = KeyTag.reversed();
    }
}

