/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.key;

import com.casper.sdk.jackson.deserializer.SignatureDeserializer;
import com.casper.sdk.model.key.AbstractSerializedKeyTaggedHex;
import com.casper.sdk.model.key.AlgorithmTag;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.syntifi.crypto.key.AbstractPrivateKey;
import com.syntifi.crypto.key.Secp256k1PrivateKey;
import com.syntifi.crypto.key.encdec.Hex;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;

@JsonDeserialize(using=SignatureDeserializer.class)
public class Signature
extends AbstractSerializedKeyTaggedHex<AlgorithmTag> {
    public static Signature sign(AbstractPrivateKey key, byte[] msg) throws GeneralSecurityException {
        byte[] signatureBytes = key.sign(msg);
        Signature signature = new Signature();
        signature.setKey(signatureBytes);
        signature.setTag(key instanceof Secp256k1PrivateKey ? AlgorithmTag.SECP256K1 : AlgorithmTag.ED25519);
        return signature;
    }

    public static Signature fromHex(String hex) throws NoSuchAlgorithmException {
        Signature signature = new Signature();
        byte[] tag = Hex.decode(hex.substring(0, 2));
        byte[] sig = Hex.decode(hex.substring(2));
        signature.setTag(AlgorithmTag.getByTag(tag[0]));
        signature.setKey(sig);
        return signature;
    }

    public static SignatureBuilder builder() {
        return new SignatureBuilder();
    }

    public static class SignatureBuilder {
        SignatureBuilder() {
        }

        public Signature build() {
            return new Signature();
        }

        public String toString() {
            return "Signature.SignatureBuilder()";
        }
    }
}

