/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.key;

import com.casper.sdk.model.key.Key;
import com.casper.sdk.model.uref.URef;
import com.casper.sdk.model.uref.URefAccessRight;
import dev.oak3.sbs4j.DeserializerBuffer;
import java.util.Arrays;

public class URefKey
extends Key {
    private URef uRef;

    @Override
    protected void deserializeCustom(DeserializerBuffer deser) throws Exception {
        byte[] bytes = deser.readByteArray(33);
        URefAccessRight access = URefAccessRight.getTypeBySerializationTag(bytes[32]);
        this.uRef = new URef(Arrays.copyOfRange(bytes, 0, 32), access);
        this.setKey(bytes);
    }

    @Override
    protected void fromStringCustom(String strKey) {
        try {
            this.uRef = URef.fromString(strKey);
            byte[] key = new byte[33];
            System.arraycopy(this.uRef.getAddress(), 0, key, 0, 32);
            key[32] = this.uRef.getAccessRight().getSerializationTag();
            this.setKey(key);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error deserializing URefKey: " + strKey, e);
        }
    }

    @Override
    public String toString() {
        return this.uRef.getJsonURef();
    }

    public URefKey(URef uRef) {
        this.uRef = uRef;
    }

    public URefKey() {
    }

    public URef getURef() {
        return this.uRef;
    }

    public void setURef(URef uRef) {
        this.uRef = uRef;
    }
}

