/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.status;

import com.casper.sdk.model.common.Digest;
import com.casper.sdk.model.common.RpcResult;
import com.casper.sdk.model.key.PublicKey;
import com.casper.sdk.model.peer.PeerEntry;
import com.casper.sdk.model.status.AvailableBlockRange;
import com.casper.sdk.model.status.BlockSynchronizerStatus;
import com.casper.sdk.model.status.MinimalBlockInfo;
import com.casper.sdk.model.status.NextUpgrade;
import com.casper.sdk.model.status.NodeState;
import com.casper.sdk.model.status.ReactorState;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.sql.Date;
import java.util.List;

public class StatusData
extends RpcResult {
    @JsonProperty(value="build_version")
    private String buildVersion;
    @JsonProperty(value="chainspec_name")
    private String chainSpecName;
    @JsonProperty(value="last_added_block_info")
    private MinimalBlockInfo lastAddedBlockInfo;
    @JsonProperty(value="next_upgrade")
    private NextUpgrade nextUpgrade;
    @JsonProperty(value="our_public_signing_key")
    private PublicKey publicKey;
    private List<PeerEntry> peers;
    @JsonProperty(value="round_length")
    private String roundLength;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String uptime;
    @JsonProperty(value="starting_state_root_hash")
    private String startStateRootHash;
    @JsonProperty(value="node_state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private NodeState nodeState;
    @JsonProperty(value="reactor_state")
    private ReactorState reactorState;
    @JsonProperty(value="last_progress")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date lastProgress;
    @JsonProperty(value="available_block_range")
    private AvailableBlockRange availableBlockRange;
    @JsonProperty(value="block_sync")
    private BlockSynchronizerStatus blockSynchronizerStatus;
    @JsonProperty(value="latest_switch_block_hash")
    private Digest lastSwitchBlockHash;

    public static StatusDataBuilder builder() {
        return new StatusDataBuilder();
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public String getChainSpecName() {
        return this.chainSpecName;
    }

    public MinimalBlockInfo getLastAddedBlockInfo() {
        return this.lastAddedBlockInfo;
    }

    public NextUpgrade getNextUpgrade() {
        return this.nextUpgrade;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public List<PeerEntry> getPeers() {
        return this.peers;
    }

    public String getRoundLength() {
        return this.roundLength;
    }

    public String getUptime() {
        return this.uptime;
    }

    public String getStartStateRootHash() {
        return this.startStateRootHash;
    }

    public NodeState getNodeState() {
        return this.nodeState;
    }

    public ReactorState getReactorState() {
        return this.reactorState;
    }

    public Date getLastProgress() {
        return this.lastProgress;
    }

    public AvailableBlockRange getAvailableBlockRange() {
        return this.availableBlockRange;
    }

    public BlockSynchronizerStatus getBlockSynchronizerStatus() {
        return this.blockSynchronizerStatus;
    }

    public Digest getLastSwitchBlockHash() {
        return this.lastSwitchBlockHash;
    }

    @JsonProperty(value="build_version")
    public void setBuildVersion(String buildVersion) {
        this.buildVersion = buildVersion;
    }

    @JsonProperty(value="chainspec_name")
    public void setChainSpecName(String chainSpecName) {
        this.chainSpecName = chainSpecName;
    }

    @JsonProperty(value="last_added_block_info")
    public void setLastAddedBlockInfo(MinimalBlockInfo lastAddedBlockInfo) {
        this.lastAddedBlockInfo = lastAddedBlockInfo;
    }

    @JsonProperty(value="next_upgrade")
    public void setNextUpgrade(NextUpgrade nextUpgrade) {
        this.nextUpgrade = nextUpgrade;
    }

    @JsonProperty(value="our_public_signing_key")
    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public void setPeers(List<PeerEntry> peers) {
        this.peers = peers;
    }

    @JsonProperty(value="round_length")
    public void setRoundLength(String roundLength) {
        this.roundLength = roundLength;
    }

    public void setUptime(String uptime) {
        this.uptime = uptime;
    }

    @JsonProperty(value="starting_state_root_hash")
    public void setStartStateRootHash(String startStateRootHash) {
        this.startStateRootHash = startStateRootHash;
    }

    @JsonProperty(value="node_state")
    public void setNodeState(NodeState nodeState) {
        this.nodeState = nodeState;
    }

    @JsonProperty(value="reactor_state")
    public void setReactorState(ReactorState reactorState) {
        this.reactorState = reactorState;
    }

    @JsonProperty(value="last_progress")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    public void setLastProgress(Date lastProgress) {
        this.lastProgress = lastProgress;
    }

    @JsonProperty(value="available_block_range")
    public void setAvailableBlockRange(AvailableBlockRange availableBlockRange) {
        this.availableBlockRange = availableBlockRange;
    }

    @JsonProperty(value="block_sync")
    public void setBlockSynchronizerStatus(BlockSynchronizerStatus blockSynchronizerStatus) {
        this.blockSynchronizerStatus = blockSynchronizerStatus;
    }

    @JsonProperty(value="latest_switch_block_hash")
    public void setLastSwitchBlockHash(Digest lastSwitchBlockHash) {
        this.lastSwitchBlockHash = lastSwitchBlockHash;
    }

    public StatusData(String buildVersion, String chainSpecName, MinimalBlockInfo lastAddedBlockInfo, NextUpgrade nextUpgrade, PublicKey publicKey, List<PeerEntry> peers, String roundLength, String uptime, String startStateRootHash, NodeState nodeState, ReactorState reactorState, Date lastProgress, AvailableBlockRange availableBlockRange, BlockSynchronizerStatus blockSynchronizerStatus, Digest lastSwitchBlockHash) {
        this.buildVersion = buildVersion;
        this.chainSpecName = chainSpecName;
        this.lastAddedBlockInfo = lastAddedBlockInfo;
        this.nextUpgrade = nextUpgrade;
        this.publicKey = publicKey;
        this.peers = peers;
        this.roundLength = roundLength;
        this.uptime = uptime;
        this.startStateRootHash = startStateRootHash;
        this.nodeState = nodeState;
        this.reactorState = reactorState;
        this.lastProgress = lastProgress;
        this.availableBlockRange = availableBlockRange;
        this.blockSynchronizerStatus = blockSynchronizerStatus;
        this.lastSwitchBlockHash = lastSwitchBlockHash;
    }

    public StatusData() {
    }

    public static class StatusDataBuilder {
        private String buildVersion;
        private String chainSpecName;
        private MinimalBlockInfo lastAddedBlockInfo;
        private NextUpgrade nextUpgrade;
        private PublicKey publicKey;
        private List<PeerEntry> peers;
        private String roundLength;
        private String uptime;
        private String startStateRootHash;
        private NodeState nodeState;
        private ReactorState reactorState;
        private Date lastProgress;
        private AvailableBlockRange availableBlockRange;
        private BlockSynchronizerStatus blockSynchronizerStatus;
        private Digest lastSwitchBlockHash;

        StatusDataBuilder() {
        }

        @JsonProperty(value="build_version")
        public StatusDataBuilder buildVersion(String buildVersion) {
            this.buildVersion = buildVersion;
            return this;
        }

        @JsonProperty(value="chainspec_name")
        public StatusDataBuilder chainSpecName(String chainSpecName) {
            this.chainSpecName = chainSpecName;
            return this;
        }

        @JsonProperty(value="last_added_block_info")
        public StatusDataBuilder lastAddedBlockInfo(MinimalBlockInfo lastAddedBlockInfo) {
            this.lastAddedBlockInfo = lastAddedBlockInfo;
            return this;
        }

        @JsonProperty(value="next_upgrade")
        public StatusDataBuilder nextUpgrade(NextUpgrade nextUpgrade) {
            this.nextUpgrade = nextUpgrade;
            return this;
        }

        @JsonProperty(value="our_public_signing_key")
        public StatusDataBuilder publicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public StatusDataBuilder peers(List<PeerEntry> peers) {
            this.peers = peers;
            return this;
        }

        @JsonProperty(value="round_length")
        public StatusDataBuilder roundLength(String roundLength) {
            this.roundLength = roundLength;
            return this;
        }

        public StatusDataBuilder uptime(String uptime) {
            this.uptime = uptime;
            return this;
        }

        @JsonProperty(value="starting_state_root_hash")
        public StatusDataBuilder startStateRootHash(String startStateRootHash) {
            this.startStateRootHash = startStateRootHash;
            return this;
        }

        @JsonProperty(value="node_state")
        public StatusDataBuilder nodeState(NodeState nodeState) {
            this.nodeState = nodeState;
            return this;
        }

        @JsonProperty(value="reactor_state")
        public StatusDataBuilder reactorState(ReactorState reactorState) {
            this.reactorState = reactorState;
            return this;
        }

        @JsonProperty(value="last_progress")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
        public StatusDataBuilder lastProgress(Date lastProgress) {
            this.lastProgress = lastProgress;
            return this;
        }

        @JsonProperty(value="available_block_range")
        public StatusDataBuilder availableBlockRange(AvailableBlockRange availableBlockRange) {
            this.availableBlockRange = availableBlockRange;
            return this;
        }

        @JsonProperty(value="block_sync")
        public StatusDataBuilder blockSynchronizerStatus(BlockSynchronizerStatus blockSynchronizerStatus) {
            this.blockSynchronizerStatus = blockSynchronizerStatus;
            return this;
        }

        @JsonProperty(value="latest_switch_block_hash")
        public StatusDataBuilder lastSwitchBlockHash(Digest lastSwitchBlockHash) {
            this.lastSwitchBlockHash = lastSwitchBlockHash;
            return this;
        }

        public StatusData build() {
            return new StatusData(this.buildVersion, this.chainSpecName, this.lastAddedBlockInfo, this.nextUpgrade, this.publicKey, this.peers, this.roundLength, this.uptime, this.startStateRootHash, this.nodeState, this.reactorState, this.lastProgress, this.availableBlockRange, this.blockSynchronizerStatus, this.lastSwitchBlockHash);
        }

        public String toString() {
            return "StatusData.StatusDataBuilder(buildVersion=" + this.buildVersion + ", chainSpecName=" + this.chainSpecName + ", lastAddedBlockInfo=" + this.lastAddedBlockInfo + ", nextUpgrade=" + this.nextUpgrade + ", publicKey=" + this.publicKey + ", peers=" + this.peers + ", roundLength=" + this.roundLength + ", uptime=" + this.uptime + ", startStateRootHash=" + this.startStateRootHash + ", nodeState=" + (Object)((Object)this.nodeState) + ", reactorState=" + (Object)((Object)this.reactorState) + ", lastProgress=" + this.lastProgress + ", availableBlockRange=" + this.availableBlockRange + ", blockSynchronizerStatus=" + this.blockSynchronizerStatus + ", lastSwitchBlockHash=" + this.lastSwitchBlockHash + ")";
        }
    }
}

