/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.transaction;

import com.casper.sdk.exception.CasperClientException;
import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.serde.CasperSerializableObject;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.common.Digest;
import com.casper.sdk.model.deploy.Approval;
import com.casper.sdk.model.transaction.AbstractTransaction;
import com.casper.sdk.model.transaction.TransactionV1Body;
import com.casper.sdk.model.transaction.TransactionV1Header;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.util.List;

@JsonPropertyOrder(value={"hash", "header", "body", "approvals"})
public class TransactionV1
extends AbstractTransaction
implements CasperSerializableObject {
    @JsonProperty(value="header")
    private TransactionV1Header header;
    @JsonProperty(value="body")
    private TransactionV1Body body;

    public TransactionV1(Digest hash, TransactionV1Header header, TransactionV1Body body, List<Approval> approvals) {
        super(hash, approvals);
        this.header = header;
        this.body = body;
    }

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        this.getHash().serialize(ser, target);
        this.header.serialize(ser, target);
        this.body.serialize(ser, target);
        this.serializeApprovals(ser, target);
    }

    @Override
    public void calculateHash() {
        try {
            this.header.setBodyHash(this.body.buildHash());
            this.setHash(this.header.buildHash());
        }
        catch (Exception e) {
            throw new CasperClientException("Error calculating hash", e);
        }
    }

    public static TransactionV1Builder builder() {
        return new TransactionV1Builder();
    }

    public TransactionV1() {
    }

    public TransactionV1(TransactionV1Header header, TransactionV1Body body) {
        this.header = header;
        this.body = body;
    }

    public TransactionV1Header getHeader() {
        return this.header;
    }

    public TransactionV1Body getBody() {
        return this.body;
    }

    @JsonProperty(value="header")
    public void setHeader(TransactionV1Header header) {
        this.header = header;
    }

    @JsonProperty(value="body")
    public void setBody(TransactionV1Body body) {
        this.body = body;
    }

    public static class TransactionV1Builder {
        private TransactionV1Header header;
        private TransactionV1Body body;
        private Digest hash;
        private List<Approval> approvals;

        TransactionV1Builder() {
        }

        @JsonProperty(value="header")
        public TransactionV1Builder header(TransactionV1Header header) {
            this.header = header;
            return this;
        }

        @JsonProperty(value="body")
        public TransactionV1Builder body(TransactionV1Body body) {
            this.body = body;
            return this;
        }

        public TransactionV1 build() {
            return new TransactionV1(this.header, this.body);
        }

        public String toString() {
            return "TransactionV1.TransactionV1Builder(header=" + this.header + ", body=" + this.body + ")";
        }

        public TransactionV1Builder hash(Digest hash) {
            this.hash = hash;
            return this;
        }

        public TransactionV1Builder approvals(List<Approval> approvals) {
            this.approvals = approvals;
            return this;
        }
    }
}

