/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.transaction;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.AbstractCLValue;
import com.casper.sdk.model.clvalue.CLValueOption;
import com.casper.sdk.model.clvalue.CLValueU64;
import com.casper.sdk.model.clvalue.serde.CasperSerializableObject;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.common.Digest;
import com.casper.sdk.model.deploy.NamedArg;
import com.casper.sdk.model.transaction.TransactionCategory;
import com.casper.sdk.model.transaction.entrypoint.TransactionEntryPoint;
import com.casper.sdk.model.transaction.scheduling.TransactionScheduling;
import com.casper.sdk.model.transaction.target.TransactionTarget;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder(value={"args", "target", "entry_point", "transaction_category", "scheduling"})
public class TransactionV1Body
implements CasperSerializableObject {
    private List<NamedArg<?>> args;
    private TransactionTarget target;
    @JsonProperty(value="entry_point")
    private TransactionEntryPoint entryPoint;
    @JsonProperty(value="transaction_category")
    private TransactionCategory transactionCategory;
    private TransactionScheduling scheduling;

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        this.serializeNamedArgs(ser, target);
        this.target.serialize(ser, target);
        this.entryPoint.serialize(ser, target);
        this.transactionCategory.serialize(ser, target);
        this.scheduling.serialize(ser, target);
    }

    void serializeNamedArgs(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        ser.writeI32(this.getArgs().size());
        for (NamedArg<?> namedArg : this.getArgs()) {
            if ("id".equals(namedArg.getType())) {
                TransactionV1Body.validateId(namedArg.getClValue());
            }
            namedArg.serialize(ser, target);
        }
    }

    public Digest buildHash() throws NoSuchTypeException, ValueSerializationException {
        SerializerBuffer serializerBuffer = new SerializerBuffer();
        this.serialize(serializerBuffer, Target.BYTE);
        return Digest.blake2bDigestFromBytes(serializerBuffer.toByteArray());
    }

    private static void validateId(AbstractCLValue<?, ?> idNamedArgValue) {
        if (!(idNamedArgValue instanceof CLValueOption)) {
            throw new IllegalArgumentException("NamedArg type 'id' must be of type CLValueOption");
        }
        CLValueOption id = (CLValueOption)idNamedArgValue;
        if (((Optional)id.getValue()).isPresent() && !(((Optional)id.getValue()).get() instanceof CLValueU64)) {
            throw new IllegalArgumentException("NamedArg type 'id' must be of type CLValueOption(CLValueU64)");
        }
    }

    public static TransactionV1BodyBuilder builder() {
        return new TransactionV1BodyBuilder();
    }

    public TransactionV1Body() {
    }

    public TransactionV1Body(List<NamedArg<?>> args, TransactionTarget target, TransactionEntryPoint entryPoint, TransactionCategory transactionCategory, TransactionScheduling scheduling) {
        this.args = args;
        this.target = target;
        this.entryPoint = entryPoint;
        this.transactionCategory = transactionCategory;
        this.scheduling = scheduling;
    }

    public List<NamedArg<?>> getArgs() {
        return this.args;
    }

    public TransactionTarget getTarget() {
        return this.target;
    }

    public TransactionEntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public TransactionCategory getTransactionCategory() {
        return this.transactionCategory;
    }

    public TransactionScheduling getScheduling() {
        return this.scheduling;
    }

    public void setArgs(List<NamedArg<?>> args) {
        this.args = args;
    }

    public void setTarget(TransactionTarget target) {
        this.target = target;
    }

    @JsonProperty(value="entry_point")
    public void setEntryPoint(TransactionEntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }

    @JsonProperty(value="transaction_category")
    public void setTransactionCategory(TransactionCategory transactionCategory) {
        this.transactionCategory = transactionCategory;
    }

    public void setScheduling(TransactionScheduling scheduling) {
        this.scheduling = scheduling;
    }

    public static class TransactionV1BodyBuilder {
        private List<NamedArg<?>> args;
        private TransactionTarget target;
        private TransactionEntryPoint entryPoint;
        private TransactionCategory transactionCategory;
        private TransactionScheduling scheduling;

        TransactionV1BodyBuilder() {
        }

        public TransactionV1BodyBuilder args(List<NamedArg<?>> args) {
            this.args = args;
            return this;
        }

        public TransactionV1BodyBuilder target(TransactionTarget target) {
            this.target = target;
            return this;
        }

        @JsonProperty(value="entry_point")
        public TransactionV1BodyBuilder entryPoint(TransactionEntryPoint entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        @JsonProperty(value="transaction_category")
        public TransactionV1BodyBuilder transactionCategory(TransactionCategory transactionCategory) {
            this.transactionCategory = transactionCategory;
            return this;
        }

        public TransactionV1BodyBuilder scheduling(TransactionScheduling scheduling) {
            this.scheduling = scheduling;
            return this;
        }

        public TransactionV1Body build() {
            return new TransactionV1Body(this.args, this.target, this.entryPoint, this.transactionCategory, this.scheduling);
        }

        public String toString() {
            return "TransactionV1Body.TransactionV1BodyBuilder(args=" + this.args + ", target=" + this.target + ", entryPoint=" + this.entryPoint + ", transactionCategory=" + this.transactionCategory + ", scheduling=" + this.scheduling + ")";
        }
    }
}

