/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.transaction;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.serde.CasperSerializableObject;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.common.Digest;
import com.casper.sdk.model.common.Ttl;
import com.casper.sdk.model.key.Tag;
import com.casper.sdk.model.transaction.InitiatorAddr;
import com.casper.sdk.model.transaction.pricing.PricingMode;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.util.Date;

public class TransactionV1Header
implements CasperSerializableObject,
Tag {
    @JsonProperty(value="chain_name")
    private String chainName;
    @JsonProperty(value="timestamp")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date timestamp;
    @JsonProperty(value="ttl")
    private Ttl ttl;
    @JsonProperty(value="body_hash")
    private Digest bodyHash;
    @JsonProperty(value="pricing_mode")
    private PricingMode pricingMode;
    @JsonProperty(value="initiator_addr")
    private InitiatorAddr initiatorAddr;

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        ser.writeString(this.chainName);
        if (this.timestamp == null) {
            this.timestamp = new Date();
        }
        ser.writeI64(this.timestamp.getTime());
        this.ttl.serialize(ser, target);
        this.bodyHash.serialize(ser, target);
        this.pricingMode.serialize(ser, target);
        this.initiatorAddr.serialize(ser, target);
    }

    @Override
    @JsonIgnore
    public byte getByteTag() {
        return 1;
    }

    public Digest buildHash() throws NoSuchTypeException, ValueSerializationException {
        SerializerBuffer serializerBuffer = new SerializerBuffer();
        this.serialize(serializerBuffer, Target.BYTE);
        return Digest.blake2bDigestFromBytes(serializerBuffer.toByteArray());
    }

    public static TransactionV1HeaderBuilder builder() {
        return new TransactionV1HeaderBuilder();
    }

    public TransactionV1Header() {
    }

    public TransactionV1Header(String chainName, Date timestamp, Ttl ttl, Digest bodyHash, PricingMode pricingMode, InitiatorAddr initiatorAddr) {
        this.chainName = chainName;
        this.timestamp = timestamp;
        this.ttl = ttl;
        this.bodyHash = bodyHash;
        this.pricingMode = pricingMode;
        this.initiatorAddr = initiatorAddr;
    }

    public String getChainName() {
        return this.chainName;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Ttl getTtl() {
        return this.ttl;
    }

    public Digest getBodyHash() {
        return this.bodyHash;
    }

    public PricingMode getPricingMode() {
        return this.pricingMode;
    }

    public InitiatorAddr getInitiatorAddr() {
        return this.initiatorAddr;
    }

    @JsonProperty(value="chain_name")
    public void setChainName(String chainName) {
        this.chainName = chainName;
    }

    @JsonProperty(value="timestamp")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty(value="ttl")
    public void setTtl(Ttl ttl) {
        this.ttl = ttl;
    }

    @JsonProperty(value="body_hash")
    public void setBodyHash(Digest bodyHash) {
        this.bodyHash = bodyHash;
    }

    @JsonProperty(value="pricing_mode")
    public void setPricingMode(PricingMode pricingMode) {
        this.pricingMode = pricingMode;
    }

    @JsonProperty(value="initiator_addr")
    public void setInitiatorAddr(InitiatorAddr initiatorAddr) {
        this.initiatorAddr = initiatorAddr;
    }

    public static class TransactionV1HeaderBuilder {
        private String chainName;
        private Date timestamp;
        private Ttl ttl;
        private Digest bodyHash;
        private PricingMode pricingMode;
        private InitiatorAddr initiatorAddr;

        TransactionV1HeaderBuilder() {
        }

        @JsonProperty(value="chain_name")
        public TransactionV1HeaderBuilder chainName(String chainName) {
            this.chainName = chainName;
            return this;
        }

        @JsonProperty(value="timestamp")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
        public TransactionV1HeaderBuilder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="ttl")
        public TransactionV1HeaderBuilder ttl(Ttl ttl) {
            this.ttl = ttl;
            return this;
        }

        @JsonProperty(value="body_hash")
        public TransactionV1HeaderBuilder bodyHash(Digest bodyHash) {
            this.bodyHash = bodyHash;
            return this;
        }

        @JsonProperty(value="pricing_mode")
        public TransactionV1HeaderBuilder pricingMode(PricingMode pricingMode) {
            this.pricingMode = pricingMode;
            return this;
        }

        @JsonProperty(value="initiator_addr")
        public TransactionV1HeaderBuilder initiatorAddr(InitiatorAddr initiatorAddr) {
            this.initiatorAddr = initiatorAddr;
            return this;
        }

        public TransactionV1Header build() {
            return new TransactionV1Header(this.chainName, this.timestamp, this.ttl, this.bodyHash, this.pricingMode, this.initiatorAddr);
        }

        public String toString() {
            return "TransactionV1Header.TransactionV1HeaderBuilder(chainName=" + this.chainName + ", timestamp=" + this.timestamp + ", ttl=" + this.ttl + ", bodyHash=" + this.bodyHash + ", pricingMode=" + this.pricingMode + ", initiatorAddr=" + this.initiatorAddr + ")";
        }
    }
}

