/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.transaction.pricing;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.transaction.pricing.PricingMode;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.math.BigInteger;

public class ClassicPricingMode
implements PricingMode {
    @JsonProperty(value="payment_amount")
    @JsonSerialize(using=ToStringSerializer.class)
    private BigInteger paymentAmount;
    @JsonProperty(value="gas_price_tolerance")
    private int gasPriceTolerance;
    @JsonProperty(value="standard_payment")
    private boolean standardPayment;

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        ser.writeU8(this.getByteTag());
        ser.writeU64(this.paymentAmount);
        ser.writeU8((byte)this.gasPriceTolerance);
        ser.writeBool(this.standardPayment);
    }

    @Override
    @JsonIgnore
    public byte getByteTag() {
        return 0;
    }

    public static ClassicPricingModeBuilder builder() {
        return new ClassicPricingModeBuilder();
    }

    public ClassicPricingMode() {
    }

    public ClassicPricingMode(BigInteger paymentAmount, int gasPriceTolerance, boolean standardPayment) {
        this.paymentAmount = paymentAmount;
        this.gasPriceTolerance = gasPriceTolerance;
        this.standardPayment = standardPayment;
    }

    public BigInteger getPaymentAmount() {
        return this.paymentAmount;
    }

    public int getGasPriceTolerance() {
        return this.gasPriceTolerance;
    }

    public boolean isStandardPayment() {
        return this.standardPayment;
    }

    @JsonProperty(value="payment_amount")
    public void setPaymentAmount(BigInteger paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    @JsonProperty(value="gas_price_tolerance")
    public void setGasPriceTolerance(int gasPriceTolerance) {
        this.gasPriceTolerance = gasPriceTolerance;
    }

    @JsonProperty(value="standard_payment")
    public void setStandardPayment(boolean standardPayment) {
        this.standardPayment = standardPayment;
    }

    public static class ClassicPricingModeBuilder {
        private BigInteger paymentAmount;
        private int gasPriceTolerance;
        private boolean standardPayment;

        ClassicPricingModeBuilder() {
        }

        @JsonProperty(value="payment_amount")
        public ClassicPricingModeBuilder paymentAmount(BigInteger paymentAmount) {
            this.paymentAmount = paymentAmount;
            return this;
        }

        @JsonProperty(value="gas_price_tolerance")
        public ClassicPricingModeBuilder gasPriceTolerance(int gasPriceTolerance) {
            this.gasPriceTolerance = gasPriceTolerance;
            return this;
        }

        @JsonProperty(value="standard_payment")
        public ClassicPricingModeBuilder standardPayment(boolean standardPayment) {
            this.standardPayment = standardPayment;
            return this;
        }

        public ClassicPricingMode build() {
            return new ClassicPricingMode(this.paymentAmount, this.gasPriceTolerance, this.standardPayment);
        }

        public String toString() {
            return "ClassicPricingMode.ClassicPricingModeBuilder(paymentAmount=" + this.paymentAmount + ", gasPriceTolerance=" + this.gasPriceTolerance + ", standardPayment=" + this.standardPayment + ")";
        }
    }
}

