/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.transaction.target;

import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.clvalue.serde.Target;
import com.casper.sdk.model.transaction.target.TransactionRuntime;
import com.casper.sdk.model.transaction.target.TransactionTarget;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import dev.oak3.sbs4j.SerializerBuffer;
import dev.oak3.sbs4j.exception.ValueSerializationException;

@JsonTypeName(value="Session")
public class Session
implements TransactionTarget {
    @JsonProperty(value="module_bytes")
    private byte[] moduleBytes;
    @JsonProperty(value="runtime")
    private TransactionRuntime runtime;

    public Session(byte[] moduleBytes, TransactionRuntime runtime) {
        this.moduleBytes = moduleBytes;
        this.runtime = runtime;
    }

    @Override
    public void serialize(SerializerBuffer ser, Target target) throws ValueSerializationException, NoSuchTypeException {
        ser.writeU8(this.getByteTag());
        if (this.moduleBytes != null) {
            ser.writeI32(this.moduleBytes.length);
            ser.writeByteArray(this.moduleBytes);
        } else {
            ser.writeI32(0);
        }
        this.runtime.serialize(ser, target);
    }

    @Override
    @JsonIgnore
    public byte getByteTag() {
        return 2;
    }

    public Session() {
    }

    public byte[] getModuleBytes() {
        return this.moduleBytes;
    }

    public TransactionRuntime getRuntime() {
        return this.runtime;
    }

    @JsonProperty(value="module_bytes")
    public void setModuleBytes(byte[] moduleBytes) {
        this.moduleBytes = moduleBytes;
    }

    @JsonProperty(value="runtime")
    public void setRuntime(TransactionRuntime runtime) {
        this.runtime = runtime;
    }
}

