/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.transfer;

import com.casper.sdk.annotation.ExcludeFromJacocoGeneratedReport;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;

public class TransferV1 {
    @JsonProperty(value="id")
    private BigInteger id;
    @JsonProperty(value="to")
    private String to;
    @JsonProperty(value="from")
    private String from;
    @JsonIgnore
    private BigInteger amount;
    @JsonProperty(value="deploy_hash")
    private String deployHash;
    @JsonProperty(value="source")
    private String source;
    @JsonProperty(value="target")
    private String target;
    @JsonIgnore
    private BigInteger gas;

    @JsonProperty(value="amount")
    @ExcludeFromJacocoGeneratedReport
    protected String getJsonAmount() {
        return this.amount.toString(10);
    }

    @JsonProperty(value="amount")
    @ExcludeFromJacocoGeneratedReport
    protected void setJsonAmount(String value) {
        this.amount = new BigInteger(value, 10);
    }

    @JsonProperty(value="gas")
    @ExcludeFromJacocoGeneratedReport
    protected String getJsonGas() {
        return this.gas.toString(10);
    }

    @JsonProperty(value="gas")
    @ExcludeFromJacocoGeneratedReport
    protected void setJsonGas(String value) {
        this.gas = new BigInteger(value, 10);
    }

    public static TransferV1Builder builder() {
        return new TransferV1Builder();
    }

    public BigInteger getId() {
        return this.id;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public String getDeployHash() {
        return this.deployHash;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public BigInteger getGas() {
        return this.gas;
    }

    @JsonProperty(value="id")
    public void setId(BigInteger id) {
        this.id = id;
    }

    @JsonProperty(value="to")
    public void setTo(String to) {
        this.to = to;
    }

    @JsonProperty(value="from")
    public void setFrom(String from) {
        this.from = from;
    }

    @JsonIgnore
    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    @JsonProperty(value="deploy_hash")
    public void setDeployHash(String deployHash) {
        this.deployHash = deployHash;
    }

    @JsonProperty(value="source")
    public void setSource(String source) {
        this.source = source;
    }

    @JsonProperty(value="target")
    public void setTarget(String target) {
        this.target = target;
    }

    @JsonIgnore
    public void setGas(BigInteger gas) {
        this.gas = gas;
    }

    public TransferV1(BigInteger id, String to, String from, BigInteger amount, String deployHash, String source, String target, BigInteger gas) {
        this.id = id;
        this.to = to;
        this.from = from;
        this.amount = amount;
        this.deployHash = deployHash;
        this.source = source;
        this.target = target;
        this.gas = gas;
    }

    public TransferV1() {
    }

    public static class TransferV1Builder {
        private BigInteger id;
        private String to;
        private String from;
        private BigInteger amount;
        private String deployHash;
        private String source;
        private String target;
        private BigInteger gas;

        TransferV1Builder() {
        }

        @JsonProperty(value="id")
        public TransferV1Builder id(BigInteger id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="to")
        public TransferV1Builder to(String to) {
            this.to = to;
            return this;
        }

        @JsonProperty(value="from")
        public TransferV1Builder from(String from) {
            this.from = from;
            return this;
        }

        @JsonIgnore
        public TransferV1Builder amount(BigInteger amount) {
            this.amount = amount;
            return this;
        }

        @JsonProperty(value="deploy_hash")
        public TransferV1Builder deployHash(String deployHash) {
            this.deployHash = deployHash;
            return this;
        }

        @JsonProperty(value="source")
        public TransferV1Builder source(String source) {
            this.source = source;
            return this;
        }

        @JsonProperty(value="target")
        public TransferV1Builder target(String target) {
            this.target = target;
            return this;
        }

        @JsonIgnore
        public TransferV1Builder gas(BigInteger gas) {
            this.gas = gas;
            return this;
        }

        public TransferV1 build() {
            return new TransferV1(this.id, this.to, this.from, this.amount, this.deployHash, this.source, this.target, this.gas);
        }

        public String toString() {
            return "TransferV1.TransferV1Builder(id=" + this.id + ", to=" + this.to + ", from=" + this.from + ", amount=" + this.amount + ", deployHash=" + this.deployHash + ", source=" + this.source + ", target=" + this.target + ", gas=" + this.gas + ")";
        }
    }
}

