/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.model.uref;

import com.casper.sdk.annotation.ExcludeFromJacocoGeneratedReport;
import com.casper.sdk.exception.DynamicInstanceException;
import com.casper.sdk.model.uref.URefAccessRight;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.oak3.sbs4j.util.ByteUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class URef {
    @JsonIgnore
    private byte[] address;
    @JsonIgnore
    private URefAccessRight accessRight;

    public static URef fromString(String uref) throws IOException, DynamicInstanceException, IllegalArgumentException {
        String[] urefParts = uref.split("-");
        if (!urefParts[0].equals("uref") || urefParts.length != 3) {
            throw new IOException("Not a valid Uref");
        }
        byte[] address = ByteUtils.parseHexString((String)urefParts[1]);
        byte[] accessRightByte = ByteUtils.parseHexString((String)urefParts[2].substring(1));
        URefAccessRight accessRight = URefAccessRight.getTypeBySerializationTag(accessRightByte[accessRightByte.length - 1]);
        return new URef(address, accessRight);
    }

    @JsonCreator
    public void createURef(String uref) throws IOException, DynamicInstanceException, IllegalArgumentException {
        URef obj = URef.fromString(uref);
        this.accessRight = obj.getAccessRight();
        this.address = obj.getAddress();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URef uRef = (URef)o;
        return Objects.deepEquals(this.address, uRef.address) && this.accessRight == uRef.accessRight;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Arrays.hashCode(this.address), this.accessRight});
    }

    @JsonValue
    @ExcludeFromJacocoGeneratedReport
    public String getJsonURef() {
        return "uref-" + ByteUtils.encodeHexString((byte[])this.address) + "-0" + ByteUtils.encodeHexString((byte[])new byte[]{this.accessRight.serializationTag});
    }

    public static URefBuilder builder() {
        return new URefBuilder();
    }

    public byte[] getAddress() {
        return this.address;
    }

    public URefAccessRight getAccessRight() {
        return this.accessRight;
    }

    @JsonIgnore
    public void setAddress(byte[] address) {
        this.address = address;
    }

    @JsonIgnore
    public void setAccessRight(URefAccessRight accessRight) {
        this.accessRight = accessRight;
    }

    public URef(byte[] address, URefAccessRight accessRight) {
        this.address = address;
        this.accessRight = accessRight;
    }

    public URef() {
    }

    public static class URefBuilder {
        private byte[] address;
        private URefAccessRight accessRight;

        URefBuilder() {
        }

        @JsonIgnore
        public URefBuilder address(byte[] address) {
            this.address = address;
            return this;
        }

        @JsonIgnore
        public URefBuilder accessRight(URefAccessRight accessRight) {
            this.accessRight = accessRight;
            return this;
        }

        public URef build() {
            return new URef(this.address, this.accessRight);
        }

        public String toString() {
            return "URef.URefBuilder(address=" + Arrays.toString(this.address) + ", accessRight=" + (Object)((Object)this.accessRight) + ")";
        }
    }
}

