/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.impl.event;

import com.casper.sdk.exception.CasperSseProcessingException;
import com.casper.sdk.model.event.Event;
import com.casper.sdk.model.event.EventTarget;
import com.casper.sdk.service.EventService;
import com.casper.sdk.service.impl.event.EventBuilder;
import com.casper.sdk.service.impl.event.EventUrlBuilder;
import java.net.URI;
import java.net.URL;
import java.util.function.Consumer;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.sse.InboundSseEvent;
import javax.ws.rs.sse.SseEvent;
import javax.ws.rs.sse.SseEventSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EventServiceImpl
implements EventService {
    private static final String APPLICATION_JSON = "application/json";
    public static final String ACCEPT = "Accept";
    public static final String CONTENT_TYPE = "Content-Type";
    private final EventUrlBuilder urlBuilder = new EventUrlBuilder();
    private final URI uri;
    private final Client sssClient = ClientBuilder.newClient();
    private final Logger logger = LoggerFactory.getLogger(EventServiceImpl.class);

    private EventServiceImpl(URI uri) {
        this.uri = uri;
    }

    @Override
    public <EventT extends Event<?>> AutoCloseable consumeEvents(EventTarget eventTarget, Long startFrom, Consumer<EventT> onEvent, Consumer<Throwable> onFailure) {
        URL url = this.urlBuilder.buildUrl(this.uri, startFrom);
        this.logger.info("Targeting SSE URL {}", (Object)url);
        WebTarget target = this.sssClient.target(url.toString());
        Response response = target.request(new String[]{"text/plain", "text/event-stream"}).get();
        EventBuilder eventBuilder = new EventBuilder(eventTarget, target.getUri().toString());
        SseEventSource source = SseEventSource.target((WebTarget)target).build();
        source.register(inboundSseEvent -> {
            if (inboundSseEvent.readData() != null) {
                this.logger.debug("SSE event id: {}, data: {}", (Object)inboundSseEvent.getId(), (Object)inboundSseEvent.readData());
                try {
                    this.consumeEvent(eventBuilder, (InboundSseEvent)inboundSseEvent, onEvent);
                }
                catch (Exception e) {
                    this.logger.error("error in consumeEvent", (Throwable)e);
                    onFailure.accept(new CasperSseProcessingException(e, (SseEvent)inboundSseEvent));
                }
            }
        }, throwable -> {
            this.logger.error("SSE Event Error on {}", (Object)url, throwable);
            onFailure.accept((Throwable)throwable);
        });
        source.open();
        return source;
    }

    private <EventT extends Event<?>> void consumeEvent(EventBuilder builder, InboundSseEvent event, Consumer<EventT> consumer) {
        if (builder.processLine(event.getId(), event.readData())) {
            consumer.accept(builder.buildEvent());
        }
    }
}

