package com.casper.sdk.model.deploy.transform;

import com.casper.sdk.model.contract.NamedKey;
import com.casper.sdk.model.transaction.kind.Kind;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

/**
 * An implmentation of Transform that Adds the given collection of named keys.
 *
 * @author Alexandre Carvalho
 * @author Andre Bertolace
 * @see Transform
 * @since 0.0.1
 */
@Getter
@Setter
@Builder
@AllArgsConstructor
@NoArgsConstructor
@JsonTypeName("AddKeys")
public class AddKeys implements Transform, Kind {

    /**
     * @see NamedKey
     */
    @JsonProperty("AddKeys")
    private List<NamedKey> addKeys;
}
