/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.helper;

import com.casper.sdk.model.clvalue.AbstractCLValue;
import com.casper.sdk.model.clvalue.CLValueByteArray;
import com.casper.sdk.model.clvalue.CLValueOption;
import com.casper.sdk.model.clvalue.CLValuePublicKey;
import com.casper.sdk.model.clvalue.CLValueU512;
import com.casper.sdk.model.clvalue.CLValueU64;
import com.casper.sdk.model.clvalue.CLValueURef;
import com.casper.sdk.model.common.Digest;
import com.casper.sdk.model.common.Ttl;
import com.casper.sdk.model.deploy.NamedArg;
import com.casper.sdk.model.key.PublicKey;
import com.casper.sdk.model.transaction.InitiatorAddr;
import com.casper.sdk.model.transaction.NamedArgs;
import com.casper.sdk.model.transaction.TransactionCategory;
import com.casper.sdk.model.transaction.TransactionV1;
import com.casper.sdk.model.transaction.TransactionV1Payload;
import com.casper.sdk.model.transaction.entrypoint.TransactionEntryPoint;
import com.casper.sdk.model.transaction.entrypoint.TransferEntryPoint;
import com.casper.sdk.model.transaction.field.Fields;
import com.casper.sdk.model.transaction.pricing.FixedPricingMode;
import com.casper.sdk.model.transaction.pricing.PricingMode;
import com.casper.sdk.model.transaction.scheduling.Standard;
import com.casper.sdk.model.transaction.scheduling.TransactionScheduling;
import com.casper.sdk.model.transaction.target.TransactionTarget;
import com.casper.sdk.model.uref.URef;
import dev.oak3.sbs4j.exception.ValueSerializationException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class TransactionHelper {
    public static <TransferTarget> TransactionV1 newTransfer(String chainName, BigInteger amount, URef maybeSource, TransferTarget target, Long maybeId) throws ValueSerializationException {
        AbstractCLValue clTarget;
        ArrayList namedArgs = new ArrayList();
        namedArgs.add(NamedArg.builder().type("amount").clValue(new CLValueU512(amount)).build());
        namedArgs.add(NamedArg.builder().type("source").clValue(new CLValueOption(Optional.ofNullable(new CLValueURef(maybeSource)))).build());
        if (target instanceof URef) {
            clTarget = new CLValueURef((URef)target);
        } else if (target instanceof PublicKey) {
            clTarget = new CLValuePublicKey((PublicKey)target);
        } else if (target instanceof Digest) {
            clTarget = new CLValueByteArray(((Digest)target).getDigest());
        } else {
            throw new IllegalArgumentException("Invalid target type " + target);
        }
        namedArgs.add(NamedArg.builder().type("target").clValue(clTarget).build());
        if (maybeId != null) {
            namedArgs.add(new NamedArg("id", new CLValueOption(Optional.ofNullable(maybeId != null ? new CLValueU64(BigInteger.valueOf(System.currentTimeMillis())) : null))));
        }
        return TransactionV1.builder().payload(TransactionV1Payload.builder().chainName(chainName).fields(Fields.builder().args(new NamedArgs(namedArgs)).scheduling(new Standard()).target((TransactionTarget)target).entryPoint(new TransferEntryPoint()).build()).pricingMode(new FixedPricingMode(0, 1)).build()).build();
    }

    public static TransactionV1 buildTransaction(InitiatorAddr<?> initiatorAddr, Ttl ttl, String chainName, PricingMode pricingMode) {
        return TransactionV1.builder().payload(TransactionV1Payload.builder().initiatorAddr(initiatorAddr).ttl(ttl).chainName(chainName).pricingMode(pricingMode).build()).build();
    }

    private static TransactionV1Payload buildTransactionPayload(List<NamedArg<?>> args, TransactionTarget target, TransactionEntryPoint entryPoint, TransactionCategory category, TransactionScheduling scheduling) {
        return TransactionV1Payload.builder().fields(Fields.builder().args(new NamedArgs(args)).entryPoint(entryPoint).scheduling(scheduling).target(target).build()).build();
    }
}

