/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.jackson.deserializer;

import com.casper.sdk.model.contract.entrypoint.EntryPointAccess;
import com.casper.sdk.model.contract.entrypoint.GroupsAccess;
import com.casper.sdk.model.contract.entrypoint.PublicAccess;
import com.casper.sdk.model.contract.entrypoint.TemplateAccess;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;

public class EntryPointAccessDeserializer
extends JsonDeserializer<EntryPointAccess> {
    public EntryPointAccess deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        if (p.getCurrentToken() == JsonToken.START_OBJECT) {
            return this.createNestedEntryPointAccess((ObjectNode)p.readValueAsTree());
        }
        if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
            return this.createSimpleEntryPointAccess(p.getValueAsString());
        }
        throw new IllegalArgumentException("Unknown scheduling type: " + p);
    }

    private EntryPointAccess createNestedEntryPointAccess(ObjectNode treeNode) {
        ArrayNode groups = (ArrayNode)treeNode.get("Groups");
        ArrayList<String> groupNames = new ArrayList<String>();
        if (groups != null) {
            groups.forEach(jsonNode -> groupNames.add(jsonNode.asText()));
        }
        return new GroupsAccess(groupNames);
    }

    private EntryPointAccess createSimpleEntryPointAccess(String valueAsString) {
        if ("Public".equals(valueAsString)) {
            return new PublicAccess();
        }
        if ("Template".equals(valueAsString)) {
            return new TemplateAccess();
        }
        throw new IllegalArgumentException("Unknown entry point access type: " + valueAsString);
    }
}

