/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.jackson.deserializer;

import com.casper.sdk.model.clvalue.cltype.AbstractCLType;
import com.casper.sdk.model.contract.entrypoint.EntryPointAccess;
import com.casper.sdk.model.contract.entrypoint.EntryPointArg;
import com.casper.sdk.model.contract.entrypoint.EntryPointType;
import com.casper.sdk.model.contract.entrypoint.EntryPointV1;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.List;

public class EntryPointV1Deserializer
extends JsonDeserializer<EntryPointV1> {
    public EntryPointV1 deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode mapNode = (JsonNode)p.getCodec().readTree(p);
        JsonNode entryPointNode = mapNode.get("entry_point");
        return EntryPointV1.builder().name(mapNode.get("name").asText()).access(this.getNestedObject(entryPointNode, ctxt, "access", EntryPointAccess.class)).ret(this.getNestedObject(entryPointNode, ctxt, "ret", AbstractCLType.class)).entryPointType(this.getNestedObject(entryPointNode, ctxt, "entry_point_type", EntryPointType.class)).args(this.getNestedObject(entryPointNode, ctxt, "args", new TypeReference<List<EntryPointArg>>(){})).build();
    }

    private <T> T getNestedObject(JsonNode node, DeserializationContext ctx, String name, Class<T> type) throws IOException {
        if (node != null) {
            try (JsonParser parser = node.get(name).traverse();){
                parser.setCodec(ctx.getParser().getCodec());
                Object object = parser.readValueAs(type);
                return (T)object;
            }
        }
        return null;
    }

    private <T> T getNestedObject(JsonNode node, DeserializationContext ctx, String name, TypeReference<T> type) throws IOException {
        if (node != null) {
            try (JsonParser parser = node.get(name).traverse();){
                parser.setCodec(ctx.getParser().getCodec());
                Object object = parser.readValueAs(type);
                return (T)object;
            }
        }
        return null;
    }
}

