/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.jackson.deserializer;

import com.casper.sdk.exception.DeserializationException;
import com.casper.sdk.exception.NoSuchTypeException;
import com.casper.sdk.model.common.Digest;
import com.casper.sdk.model.transaction.target.Native;
import com.casper.sdk.model.transaction.target.Session;
import com.casper.sdk.model.transaction.target.Stored;
import com.casper.sdk.model.transaction.target.TargetConstants;
import com.casper.sdk.model.transaction.target.TransactionInvocationTarget;
import com.casper.sdk.model.transaction.target.TransactionRuntime;
import com.casper.sdk.model.transaction.target.TransactionTarget;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.syntifi.crypto.key.encdec.Hex;
import java.io.IOException;

public class TransactionTargetDeserializer
extends JsonDeserializer<TransactionTarget> {
    private static final String NATIVE_JSON = "\"Native\"";

    public TransactionTarget deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.getCurrentToken() == JsonToken.START_OBJECT) {
            ObjectNode treeNode = (ObjectNode)p.readValueAsTree();
            String fieldName = (String)treeNode.fieldNames().next();
            if (TargetConstants.SESSION.equals(fieldName)) {
                return this.createSession(treeNode.get(fieldName));
            }
            if (TargetConstants.STORED.equals(fieldName)) {
                return this.createStored(treeNode.get(fieldName), ctxt);
            }
            throw new IllegalArgumentException("Unknown transaction target type: " + fieldName);
        }
        if (p.getCurrentToken() == JsonToken.VALUE_STRING && NATIVE_JSON.equals(p.readValueAsTree().toString())) {
            return new Native();
        }
        throw new IllegalArgumentException("Unknown  transaction target type: " + p.readValueAsTree());
    }

    private Stored createStored(JsonNode node, DeserializationContext ctx) throws IOException {
        try {
            return new Stored(this.createInvocationTarget(node, ctx), TransactionRuntime.fromJson(node.get("runtime").asText()), node.has("transferred_value") ? node.get("transferred_value").asLong() : 0L);
        }
        catch (NoSuchTypeException e) {
            throw new DeserializationException("Unable to find 'runtime'", e);
        }
    }

    private TransactionInvocationTarget createInvocationTarget(JsonNode node, DeserializationContext ctx) throws IOException {
        try (JsonParser parser = node.get("id").traverse();){
            parser.setCodec(ctx.getParser().getCodec());
            TransactionInvocationTarget transactionInvocationTarget = (TransactionInvocationTarget)parser.readValueAs(TransactionInvocationTarget.class);
            return transactionInvocationTarget;
        }
    }

    private Session createSession(JsonNode node) throws DeserializationException {
        try {
            return new Session(node.has("is_install_upgrade") && node.get("is_install_upgrade").asBoolean(), TransactionRuntime.fromJson(node.get("runtime").asText()), Hex.decode(node.get("module_bytes").asText()), node.has("transferred_value") ? node.get("transferred_value").asLong() : 0L, node.has("seed") && !node.get("seed").isNull() && !"null".equals(node.get("seed").asText()) ? new Digest(node.get("seed").asText()) : null);
        }
        catch (NoSuchTypeException e) {
            throw new DeserializationException("Unable to find required fields", e);
        }
    }
}

